/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import phex.common.log.NLogger;
import phex.http.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPRangeSet {
    private static final String BYTES = "bytes";
    public static final int NOT_SET = -1;
    private List<Range> rangeList = new ArrayList<Range>(4);

    public HTTPRangeSet() {
    }

    public HTTPRangeSet(long suffixLength) {
        this();
        Range entry = new Range(suffixLength);
        this.rangeList.add(entry);
    }

    public HTTPRangeSet(long startOffset, long endOffset) {
        this();
        Range entry = new Range(startOffset, endOffset);
        this.rangeList.add(entry);
    }

    public int size() {
        return this.rangeList.size();
    }

    public void addRange(long suffixLength) {
        Range entry = new Range(suffixLength);
        this.rangeList.add(entry);
    }

    public void addRange(long startOffset, long endOffset) {
        Range entry = new Range(startOffset, endOffset);
        this.rangeList.add(entry);
    }

    public Range getFirstRange() {
        if (this.rangeList.size() > 0) {
            return this.rangeList.get(0);
        }
        return null;
    }

    public Iterator<Range> getIterator() {
        return this.rangeList.iterator();
    }

    public String buildXAvailableRangesString() {
        if (this.rangeList.size() == 0) {
            return BYTES;
        }
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("bytes ");
        Iterator<Range> iterator = this.rangeList.iterator();
        while (iterator.hasNext()) {
            Range range = iterator.next();
            buffer.append(range.buildHTTPRangeString());
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    public static HTTPRangeSet parseHTTPRangeSet(String httpRangeSetValue, boolean allowSuffix) {
        int colonIdx;
        if (!(httpRangeSetValue = httpRangeSetValue.toLowerCase()).startsWith(BYTES)) {
            return null;
        }
        if (httpRangeSetValue.length() < 6) {
            return new HTTPRangeSet();
        }
        try {
            httpRangeSetValue = httpRangeSetValue.substring(6).trim();
        }
        catch (StringIndexOutOfBoundsException exp) {
            NLogger.error(HTTPRangeSet.class, (Object)("Invalid RangeSet value: '" + httpRangeSetValue + "'."), (Throwable)exp);
            return null;
        }
        int startIdx = 0;
        HTTPRangeSet httpRangeSet = new HTTPRangeSet();
        do {
            if ((colonIdx = httpRangeSetValue.indexOf(44, startIdx)) == -1) {
                colonIdx = httpRangeSetValue.length();
            }
            String httpRangeValue = httpRangeSetValue.substring(startIdx, colonIdx).trim();
            if (allowSuffix && httpRangeValue.charAt(0) == '-') {
                int endIdx = httpRangeValue.indexOf(32);
                if (endIdx == -1) {
                    endIdx = httpRangeValue.length();
                }
                String suffixByteRangeStr = httpRangeValue.substring(1, endIdx);
                try {
                    long suffixLength = Long.parseLong(suffixByteRangeStr);
                    httpRangeSet.addRange(suffixLength);
                }
                catch (NumberFormatException exp) {
                    return null;
                }
            }
            int dashIdx = httpRangeValue.indexOf(45);
            try {
                String startOffsetStr = httpRangeValue.substring(0, dashIdx);
                long startOffset = Long.parseLong(startOffsetStr);
                if (allowSuffix && dashIdx + 1 >= httpRangeValue.length()) {
                    httpRangeSet.addRange(startOffset, -1L);
                } else {
                    String endOffsetStr = httpRangeValue.substring(dashIdx + 1);
                    long endOffset = Long.parseLong(endOffsetStr);
                    if (endOffset >= startOffset) {
                        httpRangeSet.addRange(startOffset, endOffset);
                    }
                }
            }
            catch (IndexOutOfBoundsException exp) {
                return null;
            }
            catch (NumberFormatException exp) {
                return null;
            }
            startIdx = colonIdx + 1;
        } while (colonIdx != httpRangeSetValue.length());
        return httpRangeSet;
    }
}

