/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.io.IOException;
import java.net.SocketException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPMessageException;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.net.connection.Connection;

public class HTTPProcessor {
    private static final char SP = ' ';
    private static final char HT = '\t';

    private HTTPProcessor() {
    }

    public static HTTPRequest parseHTTPRequest(Connection connection) throws IOException, HTTPMessageException {
        String line = connection.readLine();
        if (line == null) {
            throw new IOException("Stream unexpectedly ended.");
        }
        HTTPRequest request = HTTPProcessor.parseHTTPRequest(line);
        HTTPProcessor.parseHTTPHeaders(request, connection);
        return request;
    }

    public static HTTPRequest parseHTTPRequest(String requestLine) throws HTTPMessageException {
        StringTokenizer st = new StringTokenizer(requestLine);
        String method = null;
        try {
            method = st.nextToken();
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        String uri = null;
        try {
            uri = st.nextToken();
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        String protocol = null;
        try {
            protocol = st.nextToken();
        }
        catch (NoSuchElementException e) {
            protocol = "HTTP/0.9";
        }
        if (method == null) {
            throw new HTTPMessageException("HTTPRequest has no method.");
        }
        if (uri == null) {
            throw new HTTPMessageException("HTTPRequest has no URI.");
        }
        HTTPRequest request = new HTTPRequest(method, uri, protocol, false);
        return request;
    }

    public static HTTPResponse parseHTTPResponse(Connection connection) throws IOException, HTTPMessageException {
        String line = connection.readLine();
        if (line == null) {
            throw new SocketException("Stream unexpectedly ended.");
        }
        line = line.trim();
        int firstIdx = line.indexOf(32);
        String httpVersion = null;
        try {
            httpVersion = line.substring(0, firstIdx);
        }
        catch (IndexOutOfBoundsException e) {
            httpVersion = null;
        }
        int secondIdx = -1;
        String statusCodeStr = null;
        try {
            secondIdx = line.indexOf(32, firstIdx + 1);
            if (secondIdx == -1) {
                secondIdx = line.length();
            }
            statusCodeStr = line.substring(firstIdx + 1, secondIdx);
        }
        catch (IndexOutOfBoundsException e) {
            statusCodeStr = null;
        }
        String statusReason = null;
        if (++secondIdx < line.length()) {
            try {
                statusReason = line.substring(secondIdx, line.length());
            }
            catch (IndexOutOfBoundsException e) {
                statusReason = "";
            }
        } else {
            statusReason = "";
        }
        if (httpVersion == null) {
            throw new HTTPMessageException("HTTP response has no version: " + line);
        }
        if (statusCodeStr == null) {
            throw new HTTPMessageException("HTTP response has no status code: " + line);
        }
        if (statusCodeStr.length() != 3) {
            throw new HTTPMessageException("HTTP response status code has invalid lenth: " + statusCodeStr + " Line: " + line);
        }
        short statusCode = -1;
        try {
            statusCode = Short.parseShort(statusCodeStr);
        }
        catch (NumberFormatException exp) {
            throw new HTTPMessageException("Status code of HTTP response is not valid: " + statusCodeStr);
        }
        HTTPResponse response = new HTTPResponse(httpVersion, statusCode, statusReason, false);
        HTTPProcessor.parseHTTPHeaders(response, connection);
        return response;
    }

    public static HTTPHeaderGroup parseHTTPHeaders(Connection connection) throws IOException {
        HTTPHeader header;
        HTTPHeaderGroup headers = new HTTPHeaderGroup(true);
        while ((header = HTTPProcessor.parseHTTPHeader(connection)) != null) {
            headers.addHeader(header);
        }
        return headers;
    }

    public static void parseHTTPHeaders(HTTPRequest httpRequest, Connection connection) throws IOException {
        HTTPHeader header;
        while ((header = HTTPProcessor.parseHTTPHeader(connection)) != null) {
            int n;
            String match = header.getName().toLowerCase();
            if (match.equals("content-length")) {
                n = -1;
                try {
                    n = Integer.parseInt(header.getValue());
                }
                catch (Exception e) {
                    throw new IOException("Error parsing content-length: " + header.getName() + " - " + header.getValue());
                }
                httpRequest.setContentLength(n, false);
                httpRequest.addHeader(header);
                continue;
            }
            if (match.equals("host")) {
                n = header.getValue().indexOf(58);
                if (n < 0) {
                    httpRequest.setHost(header.getValue(), -1, false);
                } else {
                    int port = -1;
                    try {
                        port = Integer.parseInt(header.getValue().substring(n + 1).trim());
                    }
                    catch (Exception e) {
                        throw new IOException("Error parsing host: " + header.getName() + " - " + header.getValue());
                    }
                    httpRequest.setHost(header.getValue().substring(0, n).trim(), port, false);
                }
                httpRequest.addHeader(header);
                continue;
            }
            httpRequest.addHeader(header);
        }
    }

    private static void parseHTTPHeaders(HTTPResponse httpRequest, Connection connection) throws IOException {
        HTTPHeader header;
        while ((header = HTTPProcessor.parseHTTPHeader(connection)) != null) {
            httpRequest.addHeader(header);
        }
    }

    private static HTTPHeader parseHTTPHeader(Connection connection) throws IOException {
        String line = connection.readLine();
        if (line == null || line.length() < 1) {
            return null;
        }
        int colon = line.indexOf(58);
        if (colon < 0) {
            throw new IOException("Invalid HTTP headers: " + line);
        }
        String name = line.substring(0, colon).trim();
        StringBuffer valueBuffer = new StringBuffer(line.substring(colon + 1).trim());
        char c = (char)connection.readPeek();
        while (c == ' ' || c == '\t') {
            int st;
            line = connection.readLine();
            int length = line.length();
            char[] val = line.toCharArray();
            for (st = 0; st < length && (val[st] == ' ' || val[st] == '\t'); ++st) {
            }
            if (st > 0) {
                line = line.substring(st, length);
            }
            valueBuffer.ensureCapacity(line.length() + 1);
            valueBuffer.append(' ');
            valueBuffer.append(line);
            c = (char)connection.readPeek();
        }
        String value = valueBuffer.toString();
        return new HTTPHeader(name, value);
    }
}

