/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.AbstractLifeCycle;
import phex.common.address.DestAddress;
import phex.connection.ConnectionObserver;
import phex.event.ChangeEvent;
import phex.event.ContainerEvent;
import phex.gui.prefs.NetworkTabPrefs;
import phex.host.Host;
import phex.host.HostStatus;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.servent.OnlineStatus;
import phex.servent.Servent;
import phex.utils.Localizer;

public final class NetworkHostsContainer
extends AbstractLifeCycle {
    private Servent servent;
    private final List<Host> networkHosts;
    private final List<Host> peerConnections;
    private final List<Host> ultrapeerConnections;
    private int leafUltrapeerConnectionCount;
    private final List<Host> leafConnections;
    private Object lock = this;

    public NetworkHostsContainer(Servent servent) {
        this.servent = servent;
        this.networkHosts = new ArrayList<Host>();
        this.peerConnections = new ArrayList<Host>();
        this.ultrapeerConnections = new ArrayList<Host>();
        this.leafConnections = new ArrayList<Host>();
        servent.getEventService().processAnnotations(this);
    }

    protected void doStart() {
        ConnectionObserver observer = new ConnectionObserver(this, this.servent.getMessageService());
        observer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShieldedLeafNode() {
        Object object = this.lock;
        synchronized (object) {
            return this.leafUltrapeerConnectionCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLeafConnections() {
        Object object = this.lock;
        synchronized (object) {
            return !this.leafConnections.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUltrapeerConnections() {
        Object object = this.lock;
        synchronized (object) {
            return !this.ultrapeerConnections.isEmpty();
        }
    }

    public boolean hasUltrapeerSlotsAvailable() {
        return this.ultrapeerConnections.size() < ConnectionPrefs.Up2UpConnections.get();
    }

    public int getOpenUltrapeerSlotsCount() {
        return ConnectionPrefs.Up2UpConnections.get() - this.ultrapeerConnections.size();
    }

    public boolean hasLeafSlotForUltrapeerAvailable() {
        return this.hasLeafSlotsAvailable() && this.ultrapeerConnections.size() < ConnectionPrefs.Up2UpConnections.get() + 1;
    }

    public boolean hasLeafSlotsAvailable() {
        return this.leafConnections.size() < ConnectionPrefs.Up2LeafConnections.get();
    }

    public int getOpenLeafSlotsCount() {
        if (this.servent.isUltrapeer()) {
            return ConnectionPrefs.Up2LeafConnections.get() - this.leafConnections.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host[] getUltrapeerConnections() {
        Object object = this.lock;
        synchronized (object) {
            Host[] hosts = new Host[this.ultrapeerConnections.size()];
            this.ultrapeerConnections.toArray(hosts);
            return hosts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host[] getLeafConnections() {
        Object object = this.lock;
        synchronized (object) {
            Host[] hosts = new Host[this.leafConnections.size()];
            this.leafConnections.toArray(hosts);
            return hosts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host[] getPeerConnections() {
        Object object = this.lock;
        synchronized (object) {
            Host[] hosts = new Host[this.peerConnections.size()];
            this.peerConnections.toArray(hosts);
            return hosts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalConnectionCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.ultrapeerConnections.size() + this.leafConnections.size() + this.peerConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeafConnectionCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.leafConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUltrapeerConnectionCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.ultrapeerConnections.size();
        }
    }

    public DestAddress[] getPushProxies() {
        if (this.isShieldedLeafNode()) {
            HashSet<DestAddress> pushProxies = new HashSet<DestAddress>();
            for (Host host : this.ultrapeerConnections) {
                DestAddress pushProxyAddress = host.getPushProxyAddress();
                if (pushProxyAddress == null) continue;
                pushProxies.add(pushProxyAddress);
                if (pushProxies.size() != 4) continue;
                break;
            }
            DestAddress[] addresses = new DestAddress[pushProxies.size()];
            pushProxies.toArray(addresses);
            return addresses;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncomingHost(Host host) {
        Object object = this.lock;
        synchronized (object) {
            this.addNetworkHost(host);
            this.addConnectedHost(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectedHost(Host host) {
        boolean isInNetwork = false;
        Object object = this.lock;
        synchronized (object) {
            isInNetwork = this.networkHosts.contains(host);
        }
        if (!isInNetwork) {
            host.disconnect();
            return;
        }
        if (host.isUltrapeer()) {
            object = this.lock;
            synchronized (object) {
                this.ultrapeerConnections.add(host);
                if (host.isLeafUltrapeerConnection()) {
                    ++this.leafUltrapeerConnectionCount;
                }
            }
        }
        if (host.isUltrapeerLeafConnection()) {
            object = this.lock;
            synchronized (object) {
                this.leafConnections.add(host);
            }
        }
        assert (false) : "Peer connections should not be used anymore";
        object = this.lock;
        synchronized (object) {
            this.peerConnections.add(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void disconnectHost(Host host) {
        if (host == null) {
            return;
        }
        if (host.isUltrapeer()) {
            Object object = this.lock;
            synchronized (object) {
                boolean isRemoved = this.ultrapeerConnections.remove(host);
                if (isRemoved && host.isLeafUltrapeerConnection()) {
                    --this.leafUltrapeerConnectionCount;
                }
            }
        }
        if (host.isUltrapeerLeafConnection()) {
            Object object = this.lock;
            synchronized (object) {
                this.leafConnections.remove(host);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.peerConnections.remove(host);
        }
        this.servent.getMessageService().removeRoutings(host);
        this.servent.getQueryService().removeHostQueries(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void periodicallyCheckHosts() {
        long currentTime = System.currentTimeMillis();
        ArrayList<Host> toDisconnect = new ArrayList<Host>();
        Object object = this.lock;
        synchronized (object) {
            Host[] badHosts = new Host[this.networkHosts.size()];
            int badHostsPos = 0;
            for (Host host : this.networkHosts) {
                HostStatus status = host.getStatus();
                if (status == HostStatus.CONNECTED) {
                    host.checkForStableConnection(currentTime);
                    String policyInfraction = null;
                    if (host.tooManyDropPackets()) {
                        policyInfraction = Localizer.getString("TooManyDroppedPackets");
                    } else if (host.isSendQueueTooLong()) {
                        policyInfraction = Localizer.getString("SendQueueTooLong");
                    } else if (host.isNoVendorDisconnectApplying()) {
                        policyInfraction = Localizer.getString("NoVendorString");
                    }
                    if (policyInfraction != null) {
                        host.setStatus(HostStatus.ERROR, policyInfraction, currentTime);
                        toDisconnect.add(host);
                    }
                }
                if (!NetworkPrefs.AutoRemoveBadHosts.get().booleanValue() || status == HostStatus.CONNECTED || status == HostStatus.CONNECTING || status == HostStatus.ACCEPTING || !host.isErrorStatusExpired(currentTime, NetworkTabPrefs.HostErrorDisplayTime.get().intValue())) continue;
                badHosts[badHostsPos] = host;
                ++badHostsPos;
            }
            if (badHostsPos > 0) {
                this.removeNetworkHosts(badHosts);
            }
        }
        for (int i = 0; i < toDisconnect.size(); ++i) {
            ((Host)toDisconnect.get(i)).disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host getNetworkHostAt(int index) {
        Object object = this.lock;
        synchronized (object) {
            if (index < 0 || index >= this.networkHosts.size()) {
                return null;
            }
            return this.networkHosts.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host[] getNetworkHostsAt(int[] indices) {
        int length = indices.length;
        Host[] hosts = new Host[length];
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < length; ++i) {
                hosts[i] = indices[i] < 0 || indices[i] >= this.networkHosts.size() ? null : this.networkHosts.get(indices[i]);
            }
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host getNetworkHost(DestAddress address) {
        Object object = this.lock;
        synchronized (object) {
            for (Host networkHost : this.networkHosts) {
                DestAddress networkAddress = networkHost.getHostAddress();
                if (!networkAddress.equals(address)) continue;
                return networkHost;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNetworkHostCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.networkHosts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNetworkHostCount(HostStatus status) {
        int count = 0;
        Object object = this.lock;
        synchronized (object) {
            for (Host host : this.networkHosts) {
                if (host.getStatus() != status) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkHost(Host host) {
        Object object = this.lock;
        synchronized (object) {
            int position = this.networkHosts.size();
            this.networkHosts.add(host);
            this.fireNetworkHostAdded(host, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectedToHost(DestAddress address) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.networkHosts.size(); ++i) {
                Host host = this.networkHosts.get(i);
                if (!host.getHostAddress().equals(address)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeAllNetworkHosts() {
        while (this.networkHosts.size() > 0) {
            Host host = this.networkHosts.get(0);
            this.internalRemoveNetworkHost(host);
        }
    }

    public void removeNetworkHosts(Host[] hosts) {
        for (Host host : hosts) {
            this.internalRemoveNetworkHost(host);
        }
    }

    public void removeNetworkHost(Host host) {
        this.internalRemoveNetworkHost(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemoveNetworkHost(Host host) {
        if (host == null) {
            return;
        }
        host.disconnect();
        Object object = this.lock;
        synchronized (object) {
            int position = this.networkHosts.indexOf(host);
            if (position >= 0) {
                this.networkHosts.remove(position);
                this.fireNetworkHostRemoved(host, position);
            }
        }
    }

    private void fireNetworkHostAdded(Host host, int position) {
        this.servent.getEventService().publish("phex:net/hosts", new ContainerEvent(ContainerEvent.Type.ADDED, host, this, position));
    }

    private void fireNetworkHostRemoved(Host host, int position) {
        this.servent.getEventService().publish("phex:net/hosts", new ContainerEvent(ContainerEvent.Type.REMOVED, host, this, position));
    }

    @EventTopicSubscriber(topic="phex:servent/onlineStatus")
    public void onOnlineStatusEvent(String topic, ChangeEvent event) {
        OnlineStatus oldStatus = (OnlineStatus)((Object)event.getOldValue());
        OnlineStatus newStatus = (OnlineStatus)((Object)event.getNewValue());
        if (newStatus == OnlineStatus.OFFLINE && oldStatus != OnlineStatus.OFFLINE) {
            this.removeAllNetworkHosts();
        }
    }
}

