/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.log.NLogger;
import phex.event.ChangeEvent;
import phex.event.ContainerEvent;
import phex.host.FavoriteHost;
import phex.net.repres.PresentationManager;
import phex.servent.Servent;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.favorites.DFavoriteHost;

public class FavoritesContainer {
    private final Servent servent;
    private final ArrayList<FavoriteHost> favoritesList;
    private boolean hasChangedSinceLastSave;

    public FavoritesContainer(Servent servent) {
        this.servent = servent;
        this.favoritesList = new ArrayList();
        this.hasChangedSinceLastSave = false;
        Environment.getInstance().scheduleTimerTask(new SaveFavoritesTimer(), 60000L, 60000L);
        this.initializeFavorites();
        servent.getEventService().processAnnotations(this);
    }

    private void initializeFavorites() {
        this.favoritesList.clear();
        this.loadFromFile();
    }

    public synchronized void addFavorites(DestAddress[] addresses) {
        for (int i = 0; i < addresses.length; ++i) {
            FavoriteHost host = new FavoriteHost(addresses[i]);
            this.insertBookmarkedHost(host, this.favoritesList.size());
        }
    }

    public synchronized void addFavorite(DestAddress address) {
        FavoriteHost host = new FavoriteHost(address);
        this.insertBookmarkedHost(host, this.favoritesList.size());
    }

    @EventTopicSubscriber(topic="phex:servent/gnutellaNetwork")
    public void onGnutellaNetworkEvent(String topic, ChangeEvent event) {
        this.saveFavoriteHosts();
        this.initializeFavorites();
    }

    private void loadFromFile() {
        NLogger.debug(FavoritesContainer.class, (Object)"Loading favorites file.");
        File favoritesFile = this.servent.getGnutellaNetwork().getFavoritesFile();
        try {
            if (!favoritesFile.exists()) {
                return;
            }
            FileManager fileMgr = FileManager.getInstance();
            ManagedFile managedFile = fileMgr.getReadWriteManagedFile(favoritesFile);
            DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug(FavoritesContainer.class, (Object)"No bookmarked hosts file found.");
                return;
            }
            DSubElementList<DFavoriteHost> dHostList = dPhex.getFavoritesList();
            if (dHostList == null) {
                NLogger.warn(FavoritesContainer.class, (Object)"No DFavoritesList found.");
                return;
            }
            for (DFavoriteHost dHost : dHostList.getSubElementList()) {
                DestAddress address;
                block11: {
                    int port = dHost.getPort();
                    address = null;
                    String hostName = dHost.getHostName();
                    byte[] ip = dHost.getIp();
                    if (hostName != null) {
                        try {
                            address = PresentationManager.getInstance().createHostAddress(hostName, port);
                            break block11;
                        }
                        catch (MalformedDestAddressException e) {
                            continue;
                        }
                    }
                    if (ip != null) {
                        address = PresentationManager.getInstance().createHostAddress(ip, port);
                    }
                }
                if (address == null) continue;
                FavoriteHost bookmarkedHost = new FavoriteHost(address);
                this.insertBookmarkedHost(bookmarkedHost, this.favoritesList.size());
            }
        }
        catch (IOException exp) {
            NLogger.error(FavoritesContainer.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
        catch (ManagedFileException exp) {
            NLogger.error(FavoritesContainer.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{exp.toString()});
            return;
        }
    }

    synchronized void saveFavoriteHosts() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        try {
            DPhex dPhex = new DPhex();
            dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
            DSubElementList<DFavoriteHost> dList = new DSubElementList<DFavoriteHost>("favorites-list");
            dPhex.setFavoritesList(dList);
            List<DFavoriteHost> list = dList.getSubElementList();
            for (FavoriteHost host : this.favoritesList) {
                DFavoriteHost dHost = new DFavoriteHost();
                DestAddress address = host.getHostAddress();
                if (address.isIpHostName()) {
                    dHost.setIp(address.getIpAddress().getHostIP());
                } else {
                    dHost.setHostName(address.getHostName());
                }
                dHost.setPort(address.getPort());
                list.add(dHost);
            }
            File favoritesFile = this.servent.getGnutellaNetwork().getFavoritesFile();
            ManagedFile managedFile = FileManager.getInstance().getReadWriteManagedFile(favoritesFile);
            XMLBuilder.saveToFile(managedFile, dPhex);
            this.hasChangedSinceLastSave = false;
        }
        catch (IOException exp) {
            NLogger.error(FavoritesContainer.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
        catch (ManagedFileException exp) {
            NLogger.error(FavoritesContainer.class, (Object)exp, (Throwable)exp);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{exp.toString()});
        }
    }

    public synchronized int getBookmarkedHostsCount() {
        return this.favoritesList.size();
    }

    public synchronized FavoriteHost getBookmarkedHostAt(int index) {
        if (index >= this.favoritesList.size()) {
            return null;
        }
        return this.favoritesList.get(index);
    }

    private synchronized void insertBookmarkedHost(FavoriteHost host, int position) {
        if (!this.favoritesList.contains(host)) {
            this.favoritesList.add(position, host);
            this.hasChangedSinceLastSave = true;
            this.fireBookmarkedHostAdded(host, position);
        }
    }

    public synchronized void removeBookmarkedHost(FavoriteHost host) {
        int position = this.favoritesList.indexOf(host);
        if (position >= 0) {
            this.favoritesList.remove(position);
            this.fireBookmarkedHostRemoved(host, position);
            this.hasChangedSinceLastSave = true;
        }
    }

    private void fireBookmarkedHostAdded(FavoriteHost host, int position) {
        this.servent.getEventService().publish("phex:net/favorites", new ContainerEvent(ContainerEvent.Type.ADDED, host, this, position));
    }

    private void fireBookmarkedHostRemoved(FavoriteHost host, int position) {
        this.servent.getEventService().publish("phex:net/favorites", new ContainerEvent(ContainerEvent.Type.REMOVED, host, this, position));
    }

    private class SaveFavoritesTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveFavoritesTimer() {
        }

        public void run() {
            try {
                Environment.getInstance().executeOnThreadPool(new SaveFavoritesRunner(), "SaveBookmarkedHosts");
            }
            catch (Throwable th) {
                NLogger.error(FavoritesContainer.class, (Object)th, th);
            }
        }
    }

    private class SaveFavoritesRunner
    implements Runnable {
        private SaveFavoritesRunner() {
        }

        public void run() {
            FavoritesContainer.this.saveFavoriteHosts();
        }
    }
}

