/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.upload;

import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.format.NumberFormatUtils;
import phex.event.ContainerEvent;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.comparator.DestAddressComparator;
import phex.gui.comparator.TransferSizeComparator;
import phex.gui.renderer.ETACellRenderer;
import phex.gui.renderer.HostAddressCellRenderer;
import phex.gui.renderer.ProgressCellRenderer;
import phex.gui.renderer.TransferSizeCellRenderer;
import phex.gui.tabs.upload.UploadStatusInfo;
import phex.servent.Servent;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.utils.Localizer;

public class UploadFilesTableModel
extends FWSortableTableModel {
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int FILE_MODEL_INDEX = 2;
    public static final int PROGRESS_MODEL_INDEX = 3;
    public static final int SIZE_MODEL_INDEX = 4;
    public static final int RATE_MODEL_INDEX = 5;
    public static final int ETA_MODEL_INDEX = 6;
    public static final int STATUS_MODEL_INDEX = 7;
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int FILE_COLUMN_ID = 1003;
    public static final int PROGRESS_COLUMN_ID = 1004;
    public static final int SIZE_COLUMN_ID = 1005;
    public static final int RATE_COLUMN_ID = 1006;
    public static final int STATUS_COLUMN_ID = 1007;
    public static final int ETA_COLUMN_ID = 1008;
    private static final Integer[] COLUMN_IDS = new Integer[]{1001, 1002, 1003, 1004, 1005, 1006, 1008, 1007};
    private static String[] tableColumns = new String[]{Localizer.getString("Host"), Localizer.getString("Vendor"), Localizer.getString("File"), Localizer.getString("PercentSign"), Localizer.getString("Size"), Localizer.getString("Rate"), Localizer.getString("UploadTable_ETA"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{HostAddressCellRenderer.class, String.class, String.class, ProgressCellRenderer.class, TransferSizeCellRenderer.class, String.class, ETACellRenderer.class, String.class};
    private UploadManager uploadMgr;

    public UploadFilesTableModel(UploadManager uploadMgr) {
        super(COLUMN_IDS, tableColumns, tableClasses);
        this.uploadMgr = uploadMgr;
        Servent.getInstance().getEventService().processAnnotations(this);
    }

    public int getRowCount() {
        return this.uploadMgr.getUploadListSize();
    }

    public Object getValueAt(int row, int col) {
        UploadState uploadState = this.uploadMgr.getUploadStateAt(row);
        if (uploadState == null) {
            this.fireTableRowsDeleted(row, row);
            return "";
        }
        switch (col) {
            case 0: {
                return uploadState.getHostAddress();
            }
            case 1: {
                String vendor = uploadState.getVendor();
                if (vendor == null) {
                    return "";
                }
                return vendor;
            }
            case 2: {
                return uploadState.getFileName();
            }
            case 3: {
                return uploadState.getProgress();
            }
            case 4: {
                return uploadState;
            }
            case 5: {
                return NumberFormatUtils.formatSignificantByteSize(uploadState.getTransferSpeed()) + Localizer.getString("PerSec");
            }
            case 6: {
                return uploadState;
            }
            case 7: {
                return UploadStatusInfo.getUploadStatusString(uploadState.getStatus());
            }
        }
        return "";
    }

    public Object getComparableValueAt(int row, int column) {
        UploadState uploadState = this.uploadMgr.getUploadStateAt(row);
        if (uploadState == null) {
            return "";
        }
        switch (column) {
            case 5: {
                return uploadState.getTransferSpeed();
            }
        }
        return this.getValueAt(row, column);
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 0: {
                return new DestAddressComparator();
            }
            case 3: {
                return ComparableComparator.getInstance();
            }
            case 4: {
                return new TransferSizeComparator();
            }
        }
        return null;
    }

    public boolean isColumnHideable(int columnIndex) {
        return columnIndex != 2;
    }

    @EventTopicSubscriber(topic="phex:upload/state")
    public void onUploadStateEvent(String topic, final ContainerEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int position = event.getPosition();
                if (event.getType() == ContainerEvent.Type.ADDED) {
                    UploadFilesTableModel.this.fireTableChanged(new TableModelEvent(UploadFilesTableModel.this, position, position, -1, 1));
                } else if (event.getType() == ContainerEvent.Type.REMOVED) {
                    UploadFilesTableModel.this.fireTableChanged(new TableModelEvent(UploadFilesTableModel.this, position, position, -1, -1));
                }
            }
        });
    }
}

