/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.security;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import phex.gui.common.table.FWTable;
import phex.security.IpSecurityRule;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;

public class SecurityRuleRowRenderer
implements TableCellRenderer {
    private static final Color darkGreen = new Color(0, 127, 0);
    private PhexSecurityManager securityMgr;

    public SecurityRuleRowRenderer() {
        Servent servent = Servent.getInstance();
        this.securityMgr = servent.getSecurityService();
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRenderer renderer = table.getDefaultRenderer(table.getColumnClass(column));
        Component comp = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        FWTable fwTable = (FWTable)table;
        int modelRow = fwTable.translateRowIndexToModel(row);
        IpSecurityRule rule = this.securityMgr.getIPAccessRule(modelRow);
        comp.setForeground(table.getSelectionForeground());
        if (rule == null || isSelected) {
            return comp;
        }
        if (rule.isDisabled()) {
            comp.setForeground(Color.lightGray);
            return comp;
        }
        if (rule.isSystemRule()) {
            comp.setForeground(Color.gray);
            return comp;
        }
        if (rule.isDenyingRule()) {
            comp.setForeground(Color.red);
        } else {
            comp.setForeground(darkGreen);
        }
        return comp;
    }
}

