/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.filterpanel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.PhexColors;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.filterpanel.FilterListPanel;
import phex.gui.tabs.search.filterpanel.QuickFilterPanel;
import phex.rules.SearchFilterRules;
import phex.utils.Localizer;

public class SearchFilterPanel
extends JPanel {
    private static Border LEFT_BUTTON_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, UIManager.getDefaults().getColor("window")), new EmptyBorder(5, 7, 5, 11));
    private SearchTab searchTab;
    private JPanel topLayoutPanel;
    private JPanel leftLayoutPanel;
    private JPanel filterContentPanel;
    private JToggleButton quickFilterBtn;
    private JToggleButton filterListBtn;
    private QuickFilterPanel quickFilterPanel;
    private FilterListPanel filterListPanel;
    private Rectangle insideBorderBounds = new Rectangle();
    private Rectangle clipBounds = new Rectangle();

    public SearchFilterPanel(SearchTab tab, SearchFilterRules filterRules) {
        this.searchTab = tab;
        this.setBorder(BorderFactory.createLineBorder(PhexColors.getBoxPanelBorderColor()));
        this.setBackground(UIManager.getDefaults().getColor("window"));
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("p, fill:p:grow", "d, fill:d:grow");
        PanelBuilder panelBuilder = new PanelBuilder(layout, this);
        this.topLayoutPanel = new JPanel();
        this.topLayoutPanel.setOpaque(false);
        layout = new FormLayout("4dlu, p, fill:8dlu:grow, p, 4dlu", "2dlu, p, 2dlu");
        PanelBuilder topBuilder = new PanelBuilder(layout, this.topLayoutPanel);
        JLabel titelLabel = new JLabel(Localizer.getString("SearchTab_SearchFilterOptions"));
        Font currentFont = titelLabel.getFont();
        Font enlargedFont = currentFont.deriveFont(1, currentFont.getSize() + 2);
        titelLabel.setFont(enlargedFont);
        topBuilder.add((Component)titelLabel, cc.xy(2, 2));
        JButton closeBtn = new JButton(tab.getTabAction("FilterPanelToggleAction"));
        closeBtn.setText(null);
        closeBtn.setIcon(GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.CloseFilterPanel"));
        closeBtn.setCursor(Cursor.getPredefinedCursor(12));
        closeBtn.setBorder(GUIUtils.ROLLOVER_BUTTON_BORDER);
        closeBtn.setRolloverEnabled(true);
        closeBtn.setOpaque(false);
        topBuilder.add((Component)closeBtn, cc.xy(4, 2));
        panelBuilder.add((Component)this.topLayoutPanel, cc.xywh(1, 1, 2, 1));
        this.leftLayoutPanel = new JPanel();
        this.leftLayoutPanel.setBackground(this.getBackground());
        this.leftLayoutPanel.setOpaque(false);
        layout = new FormLayout("4dlu, p, 0dlu", "23px, d, 0dlu, d, 23px");
        PanelBuilder leftBuilder = new PanelBuilder(layout, this.leftLayoutPanel);
        ButtonGroup leftBtnGroup = new ButtonGroup();
        this.quickFilterBtn = new JToggleButton(Localizer.getString("SearchTab_QuickFilter"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.QuickFilter"));
        this.quickFilterBtn.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(2, 2, 1, 0, this.getBackground()), new EmptyBorder(5, 7, 5, 11)));
        leftBtnGroup.add(this.quickFilterBtn);
        this.updateLeftBtnProps(this.quickFilterBtn);
        leftBuilder.add((Component)this.quickFilterBtn, cc.xy(2, 2));
        this.quickFilterBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchFilterPanel.this.activateQuickFilterPanel();
            }
        });
        this.filterListBtn = new JToggleButton(Localizer.getString("SearchTab_FilterRules"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Search.FilterList"));
        this.filterListBtn.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 2, 2, 0, this.getBackground()), new EmptyBorder(5, 7, 5, 11)));
        leftBtnGroup.add(this.filterListBtn);
        this.updateLeftBtnProps(this.filterListBtn);
        leftBuilder.add((Component)this.filterListBtn, cc.xy(2, 4));
        this.filterListBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchFilterPanel.this.activateFilterListPanel();
            }
        });
        panelBuilder.add((Component)this.leftLayoutPanel, cc.xywh(1, 2, 1, 1));
        this.quickFilterPanel = new QuickFilterPanel();
        this.filterListPanel = new FilterListPanel(filterRules);
        this.filterContentPanel = new JPanel(new BorderLayout());
        this.filterContentPanel.setOpaque(false);
        panelBuilder.add((Component)this.filterContentPanel, cc.xywh(2, 2, 1, 1));
        this.quickFilterBtn.doClick();
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        this.quickFilterPanel.setDisplayedSearch(searchResultsDataModel);
        this.filterListPanel.setDisplayedSearch(searchResultsDataModel);
    }

    public void activateQuickFilterPanel() {
        this.filterContentPanel.removeAll();
        this.filterContentPanel.add((Component)this.quickFilterPanel, "Center");
        this.filterContentPanel.doLayout();
        this.filterContentPanel.revalidate();
        this.filterContentPanel.repaint();
    }

    public void activateFilterListPanel() {
        this.filterContentPanel.removeAll();
        this.filterContentPanel.add((Component)this.filterListPanel, "Center");
        this.filterContentPanel.doLayout();
        this.filterContentPanel.revalidate();
        this.filterContentPanel.repaint();
    }

    private void updateLeftBtnProps(AbstractButton b) {
        b.setUI(new LeftButtonUI());
        b.setIconTextGap(8);
        b.setHorizontalAlignment(2);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.setRolloverEnabled(true);
        b.setOpaque(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.getClipBounds(this.clipBounds);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(this.clipBounds.x, this.clipBounds.y, this.clipBounds.width, this.clipBounds.height);
        }
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        Graphics2D g2 = (Graphics2D)g.create(insets.left, insets.top, w, h);
        try {
            this.insideBorderBounds.setBounds(0, 0, w, h);
            this.paintInsideBorder(g2);
        }
        finally {
            g2.dispose();
        }
    }

    private void paintInsideBorder(Graphics2D g2) {
        Rectangle topBounds = this.topLayoutPanel.getBounds();
        int topHeight = topBounds.height;
        Rectangle leftBounds = this.leftLayoutPanel.getBounds();
        int leftWidth = leftBounds.width;
        g2.setColor(PhexColors.getBoxPanelBackground());
        g2.fillRect(0, 0, this.insideBorderBounds.width, topHeight * 2);
        g2.fillRect(0, topHeight * 2, leftWidth, this.insideBorderBounds.height);
        g2.setColor(this.getBackground());
        g2.fillRoundRect(leftWidth, topHeight, this.insideBorderBounds.width, this.insideBorderBounds.height, 40, 40);
    }

    private static class LeftButtonUI
    extends BasicButtonUI {
        private Color rolloverColor = PhexColors.getBoxPanelBackground().darker();

        private LeftButtonUI() {
        }

        public void update(Graphics g, JComponent c) {
            AbstractButton b;
            int width = c.getWidth();
            int height = c.getHeight();
            if (c.isOpaque()) {
                g.setColor(PhexColors.getBoxPanelBackground());
                g.fillRect(0, 0, width, height);
            }
            if ((b = (AbstractButton)c).isSelected()) {
                g.setColor(c.getParent().getBackground());
                g.fillRect(0, 0, width, height);
            } else if (b.getModel().isRollover()) {
                g.setColor(this.rolloverColor);
                g.fillRect(0, 0, width, height);
            }
            this.paint(g, c);
        }
    }
}

