/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.log.NLogger;
import phex.event.ContainerEvent;
import phex.gui.common.FWButtonBar;
import phex.gui.common.GUIRegistry;
import phex.gui.tabs.search.SearchButton;
import phex.gui.tabs.search.SearchResultsDataModel;
import phex.gui.tabs.search.SearchTab;
import phex.gui.tabs.search.cp.SearchInfoBox;
import phex.query.Search;
import phex.query.SearchContainer;
import phex.servent.Servent;

public class SearchButtonBar
extends FWButtonBar {
    private final UpdateButtonsTimerAction updateButtonsAction;
    private SearchTab searchTab;
    private SearchResultsDataModel displayedDataModel;
    private SearchContainer searchContainer;
    private ButtonGroup searchButtonGroup;
    private Object accessLock = new Object();
    private AbstractButton notSelectedButton;
    private HashMap<Search, SearchButton> searchButtonMap;
    private ButtonHandler buttonHandler;

    public SearchButtonBar(SearchTab searchTab, SearchContainer searchContainer) {
        this.searchTab = searchTab;
        this.updateButtonsAction = new UpdateButtonsTimerAction();
        this.searchButtonGroup = new ButtonGroup();
        this.notSelectedButton = new JToggleButton();
        this.searchButtonGroup.add(this.notSelectedButton);
        this.searchButtonMap = new HashMap();
        this.buttonHandler = new ButtonHandler();
        this.searchContainer = searchContainer;
        int count = searchContainer.getSearchCount();
        for (int i = 0; i < count; ++i) {
            Search search = searchContainer.getSearchAt(i);
            if (search == null) continue;
            this.addSearch(search);
        }
        this.addMouseListener(new MouseListener());
        Servent.getInstance().getEventService().processAnnotations(this);
    }

    public void addNotify() {
        super.addNotify();
        GUIRegistry.getInstance().getGuiUpdateTimer().addActionListener(this.updateButtonsAction);
    }

    public void removeNotify() {
        super.removeNotify();
        GUIRegistry.getInstance().getGuiUpdateTimer().removeActionListener(this.updateButtonsAction);
    }

    public void setDisplayedSearch(SearchResultsDataModel searchResultsDataModel) {
        if (this.displayedDataModel != searchResultsDataModel) {
            this.displayedDataModel = searchResultsDataModel;
            if (searchResultsDataModel != null) {
                Search search = searchResultsDataModel.getSearch();
                SearchButton btn = this.searchButtonMap.get(search);
                if (btn != null) {
                    btn.setSelected(true);
                }
            } else {
                this.notSelectedButton.setSelected(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSearch(Search search) {
        SearchButton btn = new SearchButton(search, this.searchTab);
        btn.addActionListener(this.buttonHandler);
        Object object = this.accessLock;
        synchronized (object) {
            this.searchButtonMap.put(search, btn);
            this.searchButtonGroup.add(btn);
            this.addButton(btn);
        }
        if (this.displayedDataModel != null && search == this.displayedDataModel.getSearch()) {
            btn.setSelected(true);
        }
    }

    @EventTopicSubscriber(topic="phex:search/update")
    public void onSearchUpdateEvent(String topic, final ContainerEvent event) {
        if (this.searchContainer != event.getContainer()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Search search = (Search)event.getSource();
                if (event.getType() == ContainerEvent.Type.ADDED) {
                    SearchButtonBar.this.addSearch(search);
                } else if (event.getType() == ContainerEvent.Type.REMOVED) {
                    SearchButton btn = (SearchButton)SearchButtonBar.this.searchButtonMap.remove(search);
                    Object object = SearchButtonBar.this.accessLock;
                    synchronized (object) {
                        SearchButtonBar.this.searchButtonGroup.remove(btn);
                        SearchButtonBar.this.removeButton(btn);
                    }
                }
            }
        });
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SearchButton searchButton = (SearchButton)e.getSource();
                searchButton.updateButtonDisplay();
                SearchButtonBar.this.searchTab.refreshTabActions();
                Search search = searchButton.getSearch();
                if (search == null) {
                    return;
                }
                SearchResultsDataModel dataModel = SearchResultsDataModel.lookupResultDataModel(search);
                SearchButtonBar.this.searchTab.setDisplayedSearch(dataModel);
            }
            catch (Exception exp) {
                NLogger.error(ButtonHandler.class, (Object)exp, (Throwable)exp);
            }
        }
    }

    private final class UpdateButtonsTimerAction
    implements ActionListener {
        private UpdateButtonsTimerAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                Object object = SearchButtonBar.this.accessLock;
                synchronized (object) {
                    for (SearchButton searchButton : SearchButtonBar.this.buttons) {
                        searchButton.updateButtonDisplay();
                    }
                }
            }
            catch (Throwable th) {
                NLogger.error(SearchInfoBox.class, (Object)th, th);
            }
        }
    }

    private final class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getClickCount() == 2) {
                    SearchButtonBar.this.searchTab.setDisplayedSearch(null);
                }
            }
            catch (Throwable th) {
                NLogger.error(MouseListener.class, (Object)th, th);
            }
        }
    }
}

