/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.Environment;
import phex.common.QueryRoutingTable;
import phex.common.URN;
import phex.common.format.NumberFormatUtils;
import phex.common.log.NLogger;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWPopupMenu;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.dialogs.ExportDialog;
import phex.gui.dialogs.FilterLibraryDialog;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.library.LibraryNode;
import phex.gui.tabs.library.LibraryTreePane;
import phex.gui.tabs.library.SharedFilesTableModel;
import phex.servent.Servent;
import phex.share.ShareFile;
import phex.share.SharedFilesService;
import phex.utils.Localizer;
import phex.utils.SystemShellExecute;
import phex.utils.URLUtil;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;

public class LibraryTab
extends FWTab {
    private static final String SHARED_FILES_TABLE_IDENTIFIER = "SharedFilesTable";
    private LibraryTreePane libraryTreePane;
    private JLabel sharedFilesLabel;
    private FWTable sharedFilesTable;
    private FWPopupMenu fileTablePopup;
    private JScrollPane sharedFilesTableScrollPane;
    private SharedFilesTableModel sharedFilesModel;
    private static final String RESCAN_ACTION_KEY = "RescanAction";
    private static final String VIEW_BITZI_ACTION_KEY = "ViewBitziTicketAction";
    private static final String EXPORT_ACTION_KEY = "ExportAction";
    private static final String FILTER_ACTION_KEY = "FilterAction";
    private static final String OPEN_FILE_ACTION_KEY = "OpenFileAction";

    public LibraryTab() {
        super(1007, Localizer.getString("Library"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.Tab"), Localizer.getString("TTTLibrary"), Localizer.getChar("LibraryMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("LibraryAccelerator")), 4);
        Servent.getInstance().getEventService().processAnnotations(this);
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout tabLayout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:p:grow, 2dlu");
        PanelBuilder tabBuilder = new PanelBuilder(tabLayout, this);
        JPanel contentPanel = new JPanel();
        FWElegantPanel elegantPanel = new FWElegantPanel(Localizer.getString("Library"), contentPanel);
        tabBuilder.add((Component)elegantPanel, cc.xy(2, 2));
        FormLayout contentLayout = new FormLayout("fill:d:grow", "fill:d:grow");
        PanelBuilder contentBuilder = new PanelBuilder(contentLayout, contentPanel);
        MouseHandler mouseHandler = new MouseHandler();
        this.libraryTreePane = new LibraryTreePane(this);
        this.libraryTreePane.addTreeSelectionListener(new SelectionHandler());
        JPanel tablePanel = this.createTablePanel(guiSettings, mouseHandler);
        JSplitPane splitPane = new JSplitPane(1, this.libraryTreePane, tablePanel);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        splitPane.setDividerSize(4);
        splitPane.setOneTouchExpandable(false);
        contentBuilder.add((Component)splitPane, cc.xy(1, 1));
        this.sharedFilesLabel = new JLabel(" ");
        this.sharedFilesLabel.setHorizontalAlignment(4);
        elegantPanel.addHeaderPanelComponent(this.sharedFilesLabel, "East");
        this.fileTablePopup = new FWPopupMenu();
        FWAction action = this.getTabAction(OPEN_FILE_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        action = this.getTabAction(VIEW_BITZI_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        this.fileTablePopup.addSeparator();
        this.libraryTreePane.appendPopupSeparator();
        action = this.getTabAction(RESCAN_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        this.libraryTreePane.appendPopupAction(action);
        action = this.getTabAction(EXPORT_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        this.libraryTreePane.appendPopupAction(action);
        action = this.getTabAction(FILTER_ACTION_KEY);
        this.fileTablePopup.addAction(action);
        this.libraryTreePane.appendPopupAction(action);
    }

    private JPanel createTablePanel(DGuiSettings guiSettings, MouseHandler mouseHandler) {
        JPanel panel = new JPanel();
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "fill:d:grow, 1dlu, p");
        PanelBuilder tabBuilder = new PanelBuilder(layout, panel);
        this.sharedFilesModel = new SharedFilesTableModel();
        this.sharedFilesTable = new FWTable(new FWSortedTableModel(this.sharedFilesModel));
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.sharedFilesTable, SHARED_FILES_TABLE_IDENTIFIER);
        this.sharedFilesTable.activateAllHeaderActions();
        this.sharedFilesTable.setAutoResizeMode(0);
        this.sharedFilesTable.addMouseListener(mouseHandler);
        this.sharedFilesTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.sharedFilesTableScrollPane = FWTable.createFWTableScrollPane(this.sharedFilesTable);
        tabBuilder.add((Component)this.sharedFilesTableScrollPane, cc.xy(1, 1));
        FWToolBar shareToolbar = new FWToolBar(0);
        shareToolbar.setBorderPainted(false);
        shareToolbar.setFloatable(false);
        tabBuilder.add((Component)shareToolbar, cc.xy(1, 3));
        FWAction action = new OpenFileAction();
        this.addTabAction(OPEN_FILE_ACTION_KEY, action);
        shareToolbar.addAction(action);
        action = new ViewBitziTicketAction();
        this.addTabAction(VIEW_BITZI_ACTION_KEY, action);
        shareToolbar.addAction(action);
        shareToolbar.addSeparator();
        action = new RescanAction();
        this.addTabAction(RESCAN_ACTION_KEY, action);
        shareToolbar.addAction(action);
        action = new ExportAction();
        this.addTabAction(EXPORT_ACTION_KEY, action);
        shareToolbar.addAction(action);
        action = new FilterAction();
        this.addTabAction(FILTER_ACTION_KEY, action);
        shareToolbar.addAction(action);
        return panel;
    }

    public void updateUI() {
        super.updateUI();
        if (this.sharedFilesTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.sharedFilesTableScrollPane);
        }
    }

    @EventTopicSubscriber(topic="phex:share/update")
    public void onShareUpdateEvent(String topic, Object event) {
        if (this.sharedFilesLabel == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SharedFilesService filesService = Servent.getInstance().getSharedFilesService();
                QueryRoutingTable qrt = filesService.getLocalRoutingTable();
                String label = Localizer.getFormatedString("LibraryTab_StatsHeader", NumberFormatUtils.formatNumber(filesService.getFileCount()), NumberFormatUtils.formatSignificantByteSize((long)filesService.getTotalFileSizeInKb() * 1024L), NumberFormatUtils.formatDecimal(qrt.getFillRatio(), 2), NumberFormatUtils.formatDecimal((double)qrt.getTableSize() / 1024.0, 0));
                LibraryTab.this.sharedFilesLabel.setText(label);
            }
        });
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTable dTable = GUIUtils.createDTable(this.sharedFilesTable, SHARED_FILES_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == LibraryTab.this.sharedFilesTable) {
                LibraryTab.this.refreshTabActions();
                LibraryTab.this.fileTablePopup.show(source, x, y);
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener,
    TreeSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                LibraryTab.this.refreshTabActions();
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            final Object lastPathComponent = e.getPath().getLastPathComponent();
            Environment.getInstance().executeOnThreadPool(new Runnable(){

                public void run() {
                    LibraryTab.this.sharedFilesTable.clearSelection();
                    if (lastPathComponent instanceof LibraryNode) {
                        LibraryTab.this.sharedFilesModel.setDisplayDirectory(((LibraryNode)lastPathComponent).getSystemFile());
                    } else {
                        LibraryTab.this.sharedFilesModel.setDisplayDirectory(null);
                    }
                }
            }, "LibraryTableUpdate");
            LibraryTab.this.refreshTabActions();
        }
    }

    private class FilterAction
    extends FWAction {
        public FilterAction() {
            super(Localizer.getString("LibraryTab_Filter"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.Filter"), Localizer.getString("LibraryTab_TTTFilter"));
        }

        public void actionPerformed(ActionEvent e) {
            FilterLibraryDialog dialog = new FilterLibraryDialog();
            dialog.setVisible(true);
        }

        public void refreshActionState() {
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.ViewBitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            block4: {
                int row = LibraryTab.this.sharedFilesTable.getSelectedRow();
                row = LibraryTab.this.sharedFilesTable.translateRowIndexToModel(row);
                if (row < 0) {
                    return;
                }
                Object obj = LibraryTab.this.sharedFilesModel.getValueAt(row, 0);
                if (obj == null || !(obj instanceof ShareFile)) {
                    return;
                }
                ShareFile sFile = (ShareFile)obj;
                URN urn = sFile.getURN();
                String url = URLUtil.buildBitziLookupURL(urn);
                try {
                    BrowserLauncher.openURL(url);
                }
                catch (IOException exp) {
                    NLogger.warn(LibraryTab.class, (Object)exp);
                    Object[] dialogOptions = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int choice = JOptionPane.showOptionDialog(LibraryTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, dialogOptions, Localizer.getString("Yes"));
                    if (choice != 0) break block4;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                }
            }
        }

        public void refreshActionState() {
            int row = LibraryTab.this.sharedFilesTable.getSelectedRow();
            row = LibraryTab.this.sharedFilesTable.translateRowIndexToModel(row);
            if (row < 0) {
                this.setEnabled(false);
                return;
            }
            Object obj = LibraryTab.this.sharedFilesModel.getValueAt(row, 0);
            if (obj == null || !(obj instanceof ShareFile)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class OpenFileAction
    extends FWAction {
        OpenFileAction() {
            super(Localizer.getString("LibraryTab_OpenFile"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.OpenFile"), Localizer.getString("LibraryTab_TTTOpenFile"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File file;
                int row = LibraryTab.this.sharedFilesTable.getSelectedRow();
                row = LibraryTab.this.sharedFilesTable.translateRowIndexToModel(row);
                if (row < 0) {
                    return;
                }
                Object obj = LibraryTab.this.sharedFilesModel.getValueAt(row, 0);
                if (obj == null) {
                    return;
                }
                if (obj instanceof ShareFile) {
                    ShareFile sFile = (ShareFile)obj;
                    file = sFile.getSystemFile();
                } else if (obj instanceof File) {
                    file = (File)obj;
                } else {
                    return;
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            SystemShellExecute.launchFile(file);
                        }
                        catch (IOException exp) {
                        }
                        catch (Throwable th) {
                            NLogger.error(LibraryTab.class, (Object)th, th);
                        }
                    }
                };
                Environment.getInstance().executeOnThreadPool(runnable, "SystenShellExecute");
            }
            catch (Throwable th) {
                NLogger.error(LibraryTab.class, (Object)th, th);
            }
        }

        public void refreshActionState() {
            int row = LibraryTab.this.sharedFilesTable.getSelectedRow();
            row = LibraryTab.this.sharedFilesTable.translateRowIndexToModel(row);
            if (row < 0) {
                this.setEnabled(false);
                return;
            }
            Object obj = LibraryTab.this.sharedFilesModel.getValueAt(row, 0);
            if (obj == null) {
                this.setEnabled(false);
                return;
            }
            if (obj instanceof ShareFile || obj instanceof File) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class ExportAction
    extends FWAction {
        ExportAction() {
            super(Localizer.getString("LibraryTab_Export"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.Export"), Localizer.getString("LibraryTab_TTTExport"));
        }

        public void actionPerformed(ActionEvent e) {
            List<ShareFile> selectionList;
            int[] viewRows = LibraryTab.this.sharedFilesTable.getSelectedRows();
            if (viewRows.length > 0) {
                int[] modelRows = LibraryTab.this.sharedFilesTable.convertRowIndicesToModel(viewRows);
                selectionList = new ArrayList<ShareFile>();
                for (int i = 0; i < modelRows.length; ++i) {
                    Object obj;
                    if (modelRows[i] < 0 || (obj = LibraryTab.this.sharedFilesModel.getValueAt(modelRows[i], 0)) == null || !(obj instanceof ShareFile)) continue;
                    ShareFile sFile = (ShareFile)obj;
                    selectionList.add(sFile);
                }
            } else {
                selectionList = Collections.emptyList();
            }
            ExportDialog dialog = selectionList.isEmpty() ? new ExportDialog() : new ExportDialog(selectionList);
            dialog.setVisible(true);
        }

        public void refreshActionState() {
        }
    }

    class RescanAction
    extends FWAction {
        RescanAction() {
            super(Localizer.getString("LibraryTab_Rescan"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Library.Refresh"), Localizer.getString("LibraryTab_TTTRescan"));
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTab.this.libraryTreePane.updateFileSystem();
            GUIActionPerformer.rescanSharedFiles();
        }

        public void refreshActionState() {
        }
    }
}

