/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.download;

import java.awt.EventQueue;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.format.NumberFormatUtils;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SwarmingManager;
import phex.event.ContainerEvent;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.comparator.ETAComparator;
import phex.gui.comparator.TransferSizeComparator;
import phex.gui.renderer.DateCellRenderer;
import phex.gui.renderer.ETACellRenderer;
import phex.gui.renderer.ProgressCellRenderer;
import phex.gui.renderer.TransferSizeCellRenderer;
import phex.servent.Servent;
import phex.utils.Localizer;

public class SWDownloadTableModel
extends FWSortableTableModel {
    private static final int FILE_MODEL_INDEX = 0;
    private static final int PROGRESS_MODEL_INDEX = 1;
    private static final int SIZE_MODEL_INDEX = 2;
    private static final int RATE_MODEL_INDEX = 3;
    private static final int ETA_MODEL_INDEX = 4;
    private static final int CANDIDATE_COUNT_MODEL_INDEX = 5;
    private static final int STATUS_MODEL_INDEX = 6;
    private static final int PRIORITY_MODEL_INDEX = 7;
    private static final int SEARCH_TERM_MODEL_INDEX = 8;
    private static final int CREATED_TIME_MODEL_INDEX = 9;
    private static final int DOWNLOADED_TIME_MODEL_INDEX = 10;
    private static final int SHA1_MODEL_INDEX = 11;
    private static final Integer FILE_COLUMN_ID = 1001;
    private static final Integer PROGRESS_COLUMN_ID = 1002;
    private static final Integer SIZE_COLUMN_ID = 1003;
    private static final Integer RATE_COLUMN_ID = 1004;
    private static final Integer STATUS_COLUMN_ID = 1005;
    private static final Integer CANDIDATE_COUNT_COLUMN_ID = 1006;
    private static final Integer SEARCH_TERM_COLUMN_ID = 1007;
    private static final Integer SHA1_COLUMN_ID = 1008;
    private static final Integer PRIORITY_COLUMN_ID = 1009;
    private static final Integer CREATED_TIME_COLUMN_ID = 1010;
    private static final Integer DOWNLOADED_TIME_COLUMN_ID = 1011;
    private static final Integer ETA_COLUMN_ID = 1012;
    private static final Integer[] COLUMN_IDS = new Integer[]{FILE_COLUMN_ID, PROGRESS_COLUMN_ID, SIZE_COLUMN_ID, RATE_COLUMN_ID, ETA_COLUMN_ID, CANDIDATE_COUNT_COLUMN_ID, STATUS_COLUMN_ID, PRIORITY_COLUMN_ID, SEARCH_TERM_COLUMN_ID, CREATED_TIME_COLUMN_ID, DOWNLOADED_TIME_COLUMN_ID, SHA1_COLUMN_ID};
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("PercentSign"), Localizer.getString("Size"), Localizer.getString("Rate"), Localizer.getString("DownloadTable_ETA"), Localizer.getString("NumberOfCandidates"), Localizer.getString("Status"), Localizer.getString("Priority"), Localizer.getString("SearchTerm"), Localizer.getString("Created"), Localizer.getString("Downloaded"), Localizer.getString("SHA1")};
    private static Class<?>[] tableClasses = new Class[]{String.class, ProgressCellRenderer.class, TransferSizeCellRenderer.class, String.class, ETACellRenderer.class, String.class, String.class, Integer.class, String.class, DateCellRenderer.class, DateCellRenderer.class, String.class};
    private SwarmingManager downloadService;

    public SWDownloadTableModel(SwarmingManager downloadService) {
        super(COLUMN_IDS, tableColumns, tableClasses);
        this.downloadService = downloadService;
        Servent.getInstance().getEventService().processAnnotations(this);
    }

    public int getRowCount() {
        return this.downloadService.getDownloadFileCount();
    }

    public Object getValueAt(int row, int column) {
        SWDownloadFile download = this.downloadService.getDownloadFile(row);
        if (download == null) {
            this.fireTableRowsDeleted(row, row);
            return null;
        }
        switch (column) {
            case 0: {
                return download.getFileName();
            }
            case 1: {
                return download.getProgress();
            }
            case 2: {
                return download;
            }
            case 3: {
                long maxRate = download.getDownloadThrottlingRate();
                String maxRateStr = maxRate >= Integer.MAX_VALUE ? Localizer.getDecimalFormatSymbols().getInfinity() : NumberFormatUtils.formatSignificantByteSize(maxRate) + Localizer.getString("PerSec");
                return NumberFormatUtils.formatSignificantByteSize(download.getTransferSpeed()) + Localizer.getString("PerSec") + " (" + maxRateStr + ")";
            }
            case 4: {
                return download;
            }
            case 5: {
                return String.valueOf(download.getDownloadingCandidatesCount()) + " / " + String.valueOf(download.getQueuedCandidatesCount()) + " / " + String.valueOf(download.getCandidatesCount());
            }
            case 6: {
                return SWDownloadInfo.getDownloadFileStatusString(download.getStatus());
            }
            case 7: {
                return this.downloadService.getDownloadPriority(download);
            }
            case 8: {
                return download.getResearchSetting().getSearchTerm();
            }
            case 9: {
                return download.getCreatedDate();
            }
            case 10: {
                return download.getDownloadedDate();
            }
            case 11: {
                return download.getResearchSetting().getSHA1();
            }
        }
        return null;
    }

    public Object getComparableValueAt(int row, int column) {
        SWDownloadFile download = this.downloadService.getDownloadFile(row);
        if (download == null) {
            return null;
        }
        switch (column) {
            case 5: {
                return download.getCandidatesCount();
            }
            case 3: {
                return download.getTransferSpeed();
            }
            case 4: {
                return download;
            }
        }
        return this.getValueAt(row, column);
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 5: {
                return FWSortedTableModel.REVERSE_COMPARABLE_COMPARATOR;
            }
            case 1: {
                return FWSortedTableModel.REVERSE_COMPARABLE_COMPARATOR;
            }
            case 3: {
                return FWSortedTableModel.REVERSE_COMPARABLE_COMPARATOR;
            }
            case 4: {
                return new ETAComparator();
            }
            case 2: {
                return new ReverseComparator((Comparator)new TransferSizeComparator());
            }
            case 9: {
                return ComparableComparator.getInstance();
            }
            case 10: {
                return ComparableComparator.getInstance();
            }
        }
        return null;
    }

    public boolean isColumnHideable(int columnIndex) {
        return columnIndex != 0;
    }

    public boolean isColumnDefaultVisible(int columnIndex) {
        return columnIndex != 11 && columnIndex != 10 && columnIndex != 9;
    }

    @EventTopicSubscriber(topic="phex:download/file")
    public void onDownloadFileEvent(String topic, final ContainerEvent event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int position = event.getPosition();
                if (event.getType() == ContainerEvent.Type.ADDED) {
                    SWDownloadTableModel.this.fireTableChanged(new TableModelEvent(SWDownloadTableModel.this, position, position, -1, 1));
                } else if (event.getType() == ContainerEvent.Type.REMOVED) {
                    SWDownloadTableModel.this.fireTableChanged(new TableModelEvent(SWDownloadTableModel.this, position, position, -1, -1));
                }
            }
        });
    }
}

