/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconPack;
import phex.gui.common.LabeledIcon;
import phex.gui.tabs.search.SearchResultElement;
import phex.servent.Servent;
import phex.share.SharedFilesService;

public class SearchTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color DOWNLOAD_COLOR = new Color(0, 127, 0);
    private static final Color SHARE_COLOR = Color.lightGray;
    private SharedFilesService sharedFilesService = Servent.getInstance().getSharedFilesService();
    private SwarmingManager downloadService;
    private JTree tree;
    private Icon folderIcon;
    private LabeledIcon folderLabeledIcon;

    public SearchTreeCellRenderer(SwarmingManager downloadService) {
        this.downloadService = downloadService;
        IconPack plafIconPack = GUIRegistry.getInstance().getPlafIconPack();
        this.folderIcon = plafIconPack.getIcon("Search.ResultFolder");
        this.folderLabeledIcon = new LabeledIcon(this.folderIcon, null);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        String stringValue = this.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            if (leaf) {
                this.setDisabledIcon(this.getLeafIcon());
            } else {
                if (value instanceof SearchResultElement) {
                    int count = ((SearchResultElement)value).getRemoteFileListCount();
                    this.folderLabeledIcon.setLabel(String.valueOf(count));
                } else {
                    this.folderLabeledIcon.setLabel(null);
                }
                this.setIcon(this.folderLabeledIcon);
            }
        } else {
            this.setEnabled(true);
            if (leaf) {
                this.setIcon(this.getLeafIcon());
            } else {
                if (value instanceof SearchResultElement) {
                    int count = ((SearchResultElement)value).getRemoteFileListCount();
                    this.folderLabeledIcon.setLabel(String.valueOf(count));
                } else {
                    this.folderLabeledIcon.setLabel(null);
                }
                this.setIcon(this.folderLabeledIcon);
            }
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        RemoteFile remoteFile = value instanceof SearchResultElement ? ((SearchResultElement)value).getSingleRemoteFile() : (value instanceof RemoteFile ? (RemoteFile)value : null);
        if (remoteFile == null) {
            return "";
        }
        URN urn = remoteFile.getURN();
        boolean isShared = this.sharedFilesService.isURNShared(urn);
        if (isShared) {
            this.setForeground(SHARE_COLOR);
        } else {
            boolean isDownloaded = this.downloadService.isURNDownloaded(urn);
            if (isDownloaded) {
                this.setForeground(DOWNLOAD_COLOR);
            }
        }
        return remoteFile.getDisplayName();
    }
}

