/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.treetable.JTreeTable;
import phex.gui.tabs.search.SearchResultElement;
import phex.share.SharedFilesService;

public class SearchResultsRowRenderer
implements TableCellRenderer {
    private static final Color DOWNLOAD_COLOR = new Color(0, 127, 0);
    private static final Color SHARE_COLOR = Color.lightGray;
    private final SharedFilesService sharedFilesService;
    private final SwarmingManager swarmingMgr;

    public SearchResultsRowRenderer(SharedFilesService sharedFilesService, SwarmingManager swarmingMgr) {
        this.sharedFilesService = sharedFilesService;
        this.swarmingMgr = swarmingMgr;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isDownloaded;
        JTreeTable treeTable = (JTreeTable)table;
        TableCellRenderer renderer = table.getDefaultRenderer(table.getColumnClass(column));
        if (renderer == null) {
            throw new NullPointerException("No default renderer found for: '" + table.getColumnClass(column) + "', Column: " + column);
        }
        Component comp = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        comp.setForeground(table.getForeground());
        Object node = treeTable.getNodeOfRow(row);
        if (node == null || isSelected) {
            comp.setForeground(table.getSelectionForeground());
            return comp;
        }
        RemoteFile remoteFile = this.getRemoteFile(node);
        URN urn = remoteFile.getURN();
        boolean isShared = this.sharedFilesService.isURNShared(urn);
        if (isShared) {
            comp.setForeground(SHARE_COLOR);
            return comp;
        }
        boolean bl = isDownloaded = remoteFile.isInDownloadQueue() || this.swarmingMgr.isURNDownloaded(urn);
        if (isDownloaded) {
            comp.setForeground(DOWNLOAD_COLOR);
            return comp;
        }
        return comp;
    }

    private RemoteFile getRemoteFile(Object node) {
        if (node instanceof SearchResultElement) {
            return ((SearchResultElement)node).getSingleRemoteFile();
        }
        return (RemoteFile)node;
    }
}

