/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter.editors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.common.URN;
import phex.common.log.NLogger;
import phex.gui.dialogs.filter.RuleDescriptionPanel;
import phex.rules.condition.FileUrnCondition;
import phex.utils.Localizer;
import phex.utils.StringUtils;

public class FileUrnCondEditor
extends JDialog {
    private RuleDescriptionPanel ruleDescPanel;
    private FileUrnCondition orgCondition;
    private FileUrnCondition condition;
    private JTextField urnTF;
    private JList urnList;
    private UrnModel urnModel;

    public FileUrnCondEditor(FileUrnCondition cond, RuleDescriptionPanel descPanel, JDialog parentDialog) {
        super(parentDialog, Localizer.getString("FileUrnCondEditor_DialogTitle"), true);
        this.ruleDescPanel = descPanel;
        this.orgCondition = cond;
        this.condition = new FileUrnCondition(cond);
        this.prepareComponent();
    }

    private void prepareComponent() {
        CloseEventHandler closeEventHandler = new CloseEventHandler();
        this.addWindowListener(closeEventHandler);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, d, 2dlu, d, d:grow, 4dlu, d, 4dlu", "4dlu, p, 2dlu, p, 10dlu, p, 2dlu, p, fill:p:grow, 4dlu, p, 2dlu, p 4dlu");
        PanelBuilder contentPB = new PanelBuilder(layout, contentPanel);
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        JLabel label = new JLabel(Localizer.getString("FileUrnCondEditor_ConditionToAdd"));
        contentPB.add((Component)label, cc.xywh(2, 2, 5, 1));
        label = new JLabel(Localizer.getString("FileUrnCondEditor_Urn"));
        label.setToolTipText(Localizer.getString("FileUrnCondEditor_TTTUrn"));
        contentPB.add((Component)label, cc.xywh(2, 4, 1, 1));
        this.urnTF = new JTextField(30);
        this.urnTF.setToolTipText(Localizer.getString("FileUrnCondEditor_TTTUrn"));
        contentPB.add((Component)this.urnTF, cc.xywh(4, 4, 2, 1));
        JButton addBtn = new JButton(Localizer.getString("FileUrnCondEditor_Add"));
        addBtn.setDefaultCapable(true);
        addBtn.addActionListener(new AddActionListener());
        addBtn.setToolTipText(Localizer.getString("FileUrnCondEditor_TTTAdd"));
        contentPB.add((Component)addBtn, cc.xywh(7, 4, 1, 1));
        label = new JLabel(Localizer.getString("FileUrnCondEditor_UrnConditions"));
        contentPB.add((Component)label, cc.xywh(2, 6, 5, 1));
        this.urnModel = new UrnModel();
        this.urnList = new JList(this.urnModel);
        this.urnList.setCellRenderer(new UrnRenderer());
        contentPB.add((Component)new JScrollPane(this.urnList), cc.xywh(2, 8, 4, 2));
        JButton removeBtn = new JButton(Localizer.getString("FileUrnCondEditor_Remove"));
        removeBtn.addActionListener(new RemoveActionListener());
        removeBtn.setToolTipText(Localizer.getString("FileUrnCondEditor_TTTRemove"));
        contentPB.add((Component)removeBtn, cc.xywh(7, 8, 1, 1));
        contentPB.add((Component)new JSeparator(), cc.xywh(1, rowCount - 3, columnCount, 1));
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.addActionListener(new OkBtnListener());
        okBtn.setRequestFocusEnabled(true);
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(closeEventHandler);
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(okBtn, cancelBtn);
        contentPB.add((Component)btnPanel, cc.xywh(2, rowCount - 1, columnCount - 2, 1));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(addBtn);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public final class UrnRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
            } else {
                this.setText(((URN)value).getAsString());
            }
            return this;
        }
    }

    public final class UrnModel
    extends AbstractListModel {
        public int getSize() {
            return FileUrnCondEditor.this.condition.getUrnCount();
        }

        public Object getElementAt(int index) {
            return FileUrnCondEditor.this.condition.getUrnList().get(index);
        }

        public void fireChange() {
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }

    private final class CloseEventHandler
    extends WindowAdapter
    implements ActionListener {
        private CloseEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            FileUrnCondEditor.this.closeDialog();
        }

        public void actionPerformed(ActionEvent e) {
            FileUrnCondEditor.this.closeDialog();
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FileUrnCondEditor.this.orgCondition.update(FileUrnCondEditor.this.condition);
                FileUrnCondEditor.this.ruleDescPanel.updateRuleData();
                FileUrnCondEditor.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error(OkBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int idx = FileUrnCondEditor.this.urnList.getSelectedIndex();
            Object[] values = FileUrnCondEditor.this.urnList.getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                FileUrnCondEditor.this.condition.removeHash((URN)values[i]);
            }
            FileUrnCondEditor.this.urnModel.fireChange();
            int modelSize = FileUrnCondEditor.this.urnModel.getSize();
            if (modelSize == 0) {
                FileUrnCondEditor.this.urnTF.requestFocusInWindow();
            } else {
                FileUrnCondEditor.this.urnList.setSelectedIndex(Math.max(0, Math.min(idx, modelSize - 1)));
            }
        }
    }

    private final class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String urn = FileUrnCondEditor.this.urnTF.getText().trim();
            if (StringUtils.isEmpty(urn)) {
                return;
            }
            if (urn.indexOf(58) == -1) {
                urn = "urn:sha1:" + urn;
            }
            if (!URN.isValidURN(urn)) {
                return;
            }
            FileUrnCondEditor.this.condition.addUrn(new URN(urn));
            FileUrnCondEditor.this.urnTF.setText("");
            FileUrnCondEditor.this.urnModel.fireChange();
            FileUrnCondEditor.this.urnTF.requestFocusInWindow();
        }
    }
}

