/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.filter;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import phex.common.log.NLogger;
import phex.gui.dialogs.filter.ConditionVisualizer;
import phex.gui.dialogs.filter.ConsequenceVisualizer;
import phex.gui.dialogs.filter.RuleDescOwnerDialog;
import phex.gui.dialogs.filter.RuleDescriptionVisualizer;
import phex.gui.dialogs.filter.editors.FileNameCondEditor;
import phex.gui.dialogs.filter.editors.FileSizeCondEditor;
import phex.gui.dialogs.filter.editors.FileUrnCondEditor;
import phex.gui.dialogs.filter.editors.MediaTypeCondEditor;
import phex.rules.Rule;
import phex.rules.condition.Condition;
import phex.rules.condition.FileSizeCondition;
import phex.rules.condition.FileUrnCondition;
import phex.rules.condition.FilenameCondition;
import phex.rules.condition.MediaTypeCondition;
import phex.rules.condition.NotCondition;
import phex.rules.consequence.Consequence;
import phex.utils.Localizer;

public class RuleDescriptionPanel
extends JPanel {
    private RuleDescOwnerDialog parent;
    private JTextPane ruleDescArea;

    public RuleDescriptionPanel(RuleDescOwnerDialog parent) {
        this.parent = parent;
        this.prepareComponent();
    }

    private void prepareComponent() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("fill:d:grow", "p, 2dlu, fill:75dlu:grow");
        PanelBuilder contentPB = new PanelBuilder(layout, this);
        JLabel label = new JLabel(Localizer.getString("RuleWizard_RuleDescription"));
        contentPB.add((Component)label, cc.xywh(1, 1, 1, 1));
        this.ruleDescArea = new JTextPane();
        this.ruleDescArea.setEditable(false);
        DescPaneMouseListener mouseListener = new DescPaneMouseListener();
        this.ruleDescArea.addMouseListener(mouseListener);
        this.ruleDescArea.addMouseMotionListener(mouseListener);
        contentPB.add((Component)new JScrollPane(this.ruleDescArea), cc.xywh(1, 3, 1, 1));
    }

    public void updateRuleData() {
        Rule rule = this.parent.getEditRule();
        try {
            StyledDocument doc = this.ruleDescArea.getStyledDocument();
            doc.remove(0, doc.getLength());
            if (rule == null) {
                return;
            }
            this.ruleDescArea.setEnabled(!rule.isDefaultRule());
            RuleDescriptionVisualizer.insertStandardPart(Localizer.getString("RuleVisualization_Prefix"), rule, doc);
            List<Condition> conditionsList = rule.getConditions();
            Iterator<Cloneable> iterator = conditionsList.iterator();
            boolean isFirst = true;
            while (iterator.hasNext()) {
                Condition condition = iterator.next();
                if (condition instanceof NotCondition) continue;
                ConditionVisualizer.visualize(condition, !isFirst, doc);
                isFirst = false;
            }
            List<Consequence> consequencesList = rule.getConsequences();
            iterator = consequencesList.iterator();
            isFirst = true;
            while (iterator.hasNext()) {
                Consequence consequence = (Consequence)iterator.next();
                ConsequenceVisualizer.visualize(consequence, !isFirst, doc);
                isFirst = false;
            }
            conditionsList = rule.getConditions();
            iterator = conditionsList.iterator();
            isFirst = true;
            while (iterator.hasNext()) {
                Condition condition = (Condition)iterator.next();
                if (!(condition instanceof NotCondition)) continue;
                ConditionVisualizer.visualize(condition, !isFirst, doc);
                isFirst = false;
            }
        }
        catch (BadLocationException exp) {
            NLogger.error(this.getClass(), (Object)exp, (Throwable)exp);
        }
    }

    private JDialog determineRuleLinkEditor(Object reference) {
        if (reference instanceof NotCondition) {
            reference = ((NotCondition)reference).getContainedCondition();
        }
        if (reference instanceof FileSizeCondition) {
            return new FileSizeCondEditor((FileSizeCondition)reference, this, (JDialog)((Object)this.parent));
        }
        if (reference instanceof FilenameCondition) {
            return new FileNameCondEditor((FilenameCondition)reference, this, (JDialog)((Object)this.parent));
        }
        if (reference instanceof FileUrnCondition) {
            return new FileUrnCondEditor((FileUrnCondition)reference, this, (JDialog)((Object)this.parent));
        }
        if (reference instanceof MediaTypeCondition) {
            return new MediaTypeCondEditor((MediaTypeCondition)reference, this, (JDialog)((Object)this.parent));
        }
        throw new IllegalArgumentException("Unknown rule link editor.");
    }

    private class DescPaneMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private final Cursor LINK_CURSOR = Cursor.getPredefinedCursor(12);
        private final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
        private Position.Bias[] bias = new Position.Bias[1];
        private Element curElem = null;
        private Element linkElem = null;

        private DescPaneMouseListener() {
        }

        public void mouseMoved(MouseEvent e) {
            JTextPane editor = (JTextPane)e.getSource();
            boolean adjustCursor = true;
            Cursor newCursor = this.DEFAULT_CURSOR;
            if (!editor.isEditable()) {
                Point pt = new Point(e.getX(), e.getY());
                int pos = editor.getUI().viewToModel(editor, pt, this.bias);
                if (this.bias[0] == Position.Bias.Backward && pos > 0) {
                    --pos;
                }
                if (pos >= 0) {
                    StyledDocument hdoc = (StyledDocument)editor.getDocument();
                    Element elem = hdoc.getCharacterElement(pos);
                    if (!this.doesElementContainLocation(editor, elem, pos, e.getX(), e.getY())) {
                        elem = null;
                    }
                    if (this.curElem != elem) {
                        AttributeSet attributes;
                        Object link;
                        this.curElem = elem;
                        Element tmpLinkElem = null;
                        if (elem != null && (link = (attributes = elem.getAttributes()).getAttribute("Link")) != null) {
                            tmpLinkElem = elem;
                        }
                        if (tmpLinkElem != this.linkElem) {
                            this.linkElem = tmpLinkElem;
                            if (tmpLinkElem != null) {
                                newCursor = this.LINK_CURSOR;
                            }
                        } else {
                            adjustCursor = false;
                        }
                    } else {
                        adjustCursor = false;
                    }
                }
            }
            if (adjustCursor && editor.getCursor() != newCursor) {
                editor.setCursor(newCursor);
            }
        }

        private boolean doesElementContainLocation(JEditorPane editor, Element e, int offset, int x, int y) {
            if (e != null && offset > 0 && e.getStartOffset() == offset) {
                try {
                    TextUI ui = editor.getUI();
                    Rectangle s1 = ui.modelToView(editor, offset, Position.Bias.Forward);
                    if (s1 == null) {
                        return false;
                    }
                    Rectangle r1 = s1 instanceof Rectangle ? s1 : s1.getBounds();
                    Rectangle s2 = ui.modelToView(editor, e.getEndOffset(), Position.Bias.Backward);
                    if (s2 != null) {
                        Rectangle r2 = s2 instanceof Rectangle ? s2 : s2.getBounds();
                        r1.add(r2);
                    }
                    return r1.contains(x, y);
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
            return true;
        }

        public void mouseClicked(MouseEvent e) {
            if (this.linkElem == null) {
                return;
            }
            AttributeSet atts = this.linkElem.getAttributes();
            Object reference = atts.getAttribute("Link");
            JDialog dialog = RuleDescriptionPanel.this.determineRuleLinkEditor(reference);
            dialog.show();
            RuleDescriptionPanel.this.updateRuleData();
        }

        public void mouseDragged(MouseEvent e) {
        }
    }
}

