/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.configwizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JPanel;
import phex.common.bandwidth.BandwidthManager;
import phex.gui.common.BandwidthComboBox;
import phex.gui.common.HTMLMultiLinePanel;
import phex.gui.dialogs.configwizard.ConfigurationWizardDialog;
import phex.prefs.core.BandwidthPrefs;
import phex.utils.Localizer;

public class BandwidthPanel
extends JPanel {
    private final ConfigurationWizardDialog parent;
    private final BandwidthManager bandwidthManager;
    private BandwidthComboBox connectionSpeedCbx;

    public BandwidthPanel(BandwidthManager bandwidthManager, ConfigurationWizardDialog parent) {
        this.bandwidthManager = bandwidthManager;
        this.parent = parent;
        this.prepareComponent();
    }

    private void prepareComponent() {
        FormLayout layout = new FormLayout("10dlu, d, 2dlu, d, right:d:grow", "p, 3dlu, p, 8dlu, p, 8dlu, p");
        this.setLayout(layout);
        PanelBuilder builder = new PanelBuilder(layout, this);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("ConfigWizard_BandwidthHeader"), cc.xywh(1, 1, 5, 1));
        HTMLMultiLinePanel welcomeLines = new HTMLMultiLinePanel(Localizer.getString("ConfigWizard_BandwidthText"));
        builder.add((Component)welcomeLines, cc.xywh(2, 3, 4, 1));
        builder.addLabel(Localizer.getString("ConfigWizard_ConnectionTypeSpeed"), cc.xy(2, 5));
        this.connectionSpeedCbx = new BandwidthComboBox();
        builder.add((Component)this.connectionSpeedCbx, cc.xy(4, 5));
        HTMLMultiLinePanel welcomeLines2 = new HTMLMultiLinePanel(Localizer.getString("ConfigWizard_BandwidthText2"));
        builder.add((Component)welcomeLines2, cc.xywh(2, 7, 4, 1));
        int netSpeed = BandwidthPrefs.NetworkSpeedKbps.get();
        for (int i = 0; i < BandwidthComboBox.SPEED_DEFINITIONS.length; ++i) {
            BandwidthComboBox.SpeedDefinition currentDef = BandwidthComboBox.SPEED_DEFINITIONS[i];
            int speedDiff = currentDef.getSpeedInKbps() - netSpeed;
            if (speedDiff < 0) continue;
            this.connectionSpeedCbx.setSelectedIndex(i);
            break;
        }
    }

    public void saveSettings() {
        BandwidthComboBox.SpeedDefinition def = this.connectionSpeedCbx.getSelectedSpeedDefinition();
        int value = def.getSpeedInKbps();
        if (value != BandwidthPrefs.NetworkSpeedKbps.get()) {
            BandwidthPrefs.NetworkSpeedKbps.set(value);
            this.bandwidthManager.setServentBandwidth(Integer.MAX_VALUE);
            this.bandwidthManager.setNetworkBandwidth(Integer.MAX_VALUE);
            this.bandwidthManager.setDownloadBandwidth(Integer.MAX_VALUE);
            this.bandwidthManager.setUploadBandwidth(Integer.MAX_VALUE);
        }
    }
}

