/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import phex.common.log.NLogger;
import phex.download.RemoteFile;
import phex.download.strategy.AvailBeginRandSelectionStrategy;
import phex.download.strategy.BeginAvailRandSelectionStrategy;
import phex.download.strategy.BeginEndAvailRandSelectionStrategy;
import phex.download.strategy.RandomScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategy;
import phex.download.strategy.ScopeSelectionStrategyProvider;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.gui.common.DialogBanner;
import phex.gui.common.FileDialogHandler;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.prefs.core.DownloadPrefs;
import phex.servent.Servent;
import phex.utils.FileUtils;
import phex.utils.Localizer;
import phex.utils.StringUtils;

public class DownloadConfigDialog
extends JDialog {
    private JTextField fileNameTF;
    private JTextField destDirectoryTF;
    private JTextField searchTermTF;
    private JComboBox downloadStrategyCbx;
    private JRadioButton topPriority;
    private JRadioButton bottomPriority;
    private RemoteFile remoteFile;
    private SWDownloadFile downloadFile;
    private JCheckBox switchToDownloadTab;

    public DownloadConfigDialog(RemoteFile remoteFile) throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ConfigDownload_DialogTitleNew"), true);
        this.remoteFile = remoteFile;
        this.prepareComponent();
        this.fillFields();
    }

    public DownloadConfigDialog(SWDownloadFile downloadFile) throws HeadlessException {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("ConfigDownload_DialogTitleConfig"), false);
        this.downloadFile = downloadFile;
        this.prepareComponent();
        this.fillFields();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DownloadConfigDialog.this.closeDialog();
            }
        });
        CellConstraints cc = new CellConstraints();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPane.add((Component)contentPanel, "Center");
        FormLayout layout = new FormLayout("4dlu, d, 2dlu, d, 2dlu, fill:d:grow, 2dlu, fill:d:grow, 2dlu, d, 4dlu", "p, p, 10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 10dlu, p, 3dlu, p, 3dlu, p,10dlu, p, 3dlu, p, 6dlu");
        PanelBuilder builder = new PanelBuilder(layout, contentPanel);
        int row = 1;
        DialogBanner banner = new DialogBanner(Localizer.getString("ConfigDownload_BannerHeader"), Localizer.getString("ConfigDownload_BannerSubHeader"));
        builder.add((Component)banner, cc.xywh(1, row, 11, 1));
        builder.add((Component)new JSeparator(), cc.xywh(1, ++row, 11, 1));
        builder.addSeparator(Localizer.getString("ConfigDownload_File"), cc.xywh(2, row += 2, 9, 1));
        builder.addLabel(Localizer.getString("ConfigDownload_FileName"), cc.xy(4, row += 2, "left, center"));
        this.fileNameTF = new JTextField(40);
        builder.add((Component)this.fileNameTF, cc.xywh(6, row, 3, 1));
        builder.addLabel(Localizer.getString("ConfigDownload_DestinationDirectory"), cc.xy(4, row += 2, "left, center"));
        this.destDirectoryTF = new JTextField(40);
        builder.add((Component)this.destDirectoryTF, cc.xywh(6, row, 3, 1));
        JButton browseDestDirBtn = new JButton(Localizer.getString("ConfigDownload_Browse"));
        browseDestDirBtn.addActionListener(new BrowseDestDirBtnListener());
        builder.add((Component)browseDestDirBtn, cc.xy(10, row));
        builder.addLabel(Localizer.getString("ConfigDownload_ReSearchTerm"), cc.xy(4, row += 2, "left, center"));
        this.searchTermTF = new JTextField(40);
        builder.add((Component)this.searchTermTF, cc.xywh(6, row, 3, 1));
        builder.addSeparator(Localizer.getString("ConfigDownload_Options"), cc.xywh(2, row += 2, 9, 1));
        builder.addLabel(Localizer.getString("ConfigDownload_DownloadStrategy"), cc.xy(4, row += 2, "left, center"));
        String[] strategyArr = new String[]{Localizer.getString("DownloadTab_StrategyAvailability"), Localizer.getString("DownloadTab_StrategyBeginning"), Localizer.getString("DownloadTab_StrategyBeginningEnd"), Localizer.getString("DownloadTab_StrategyRandom")};
        this.downloadStrategyCbx = new JComboBox<String>(strategyArr);
        builder.add((Component)this.downloadStrategyCbx, cc.xywh(6, row, 3, 1));
        row += 2;
        if (this.remoteFile != null) {
            builder.addLabel(Localizer.getString("ConfigDownload_Priority"), cc.xy(4, row, "left, center"));
            ButtonGroup priorityGroup = new ButtonGroup();
            this.topPriority = new JRadioButton(Localizer.getString("ConfigDownload_AddToTop"));
            this.bottomPriority = new JRadioButton(Localizer.getString("ConfigDownload_AddToBottom"));
            priorityGroup.add(this.topPriority);
            priorityGroup.add(this.bottomPriority);
            builder.add((Component)this.topPriority, cc.xywh(6, row, 1, 1));
            builder.add((Component)this.bottomPriority, cc.xywh(8, row, 1, 1));
        }
        builder.add((Component)new JSeparator(), cc.xywh(1, row += 2, 11, 1));
        row += 2;
        if (this.remoteFile != null) {
            this.switchToDownloadTab = new JCheckBox(Localizer.getString("ConfigDownload_SwitchToDownloadTab"));
            builder.add((Component)this.switchToDownloadTab, cc.xywh(2, row, 5, 1));
        }
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(new CancelBtnListener());
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.addActionListener(new OkBtnListener());
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar(okBtn, cancelBtn);
        builder.add((Component)btnPanel, cc.xywh(8, row, 3, 1));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void fillFields() {
        if (this.remoteFile != null) {
            this.fileNameTF.setText(this.remoteFile.getFilename());
            this.destDirectoryTF.setText(DownloadPrefs.DestinationDirectory.get());
            this.searchTermTF.setText(StringUtils.createNaturalSearchTerm(this.remoteFile.getDisplayName()));
            this.downloadStrategyCbx.setSelectedIndex(0);
            this.topPriority.setSelected(true);
        } else if (this.downloadFile != null) {
            this.fileNameTF.setText(this.downloadFile.getFileName());
            File destDir = this.downloadFile.getDestinationDirectory();
            String destDirStr = destDir != null ? destDir.getAbsolutePath() : DownloadPrefs.DestinationDirectory.get();
            this.destDirectoryTF.setText(destDirStr);
            this.searchTermTF.setText(this.downloadFile.getResearchSetting().getSearchTerm());
            ScopeSelectionStrategy strategy = this.downloadFile.getMemoryFile().getScopeSelectionStrategy();
            if (strategy instanceof AvailBeginRandSelectionStrategy) {
                this.downloadStrategyCbx.setSelectedIndex(0);
            } else if (strategy instanceof BeginAvailRandSelectionStrategy) {
                this.downloadStrategyCbx.setSelectedIndex(1);
            } else if (strategy instanceof BeginEndAvailRandSelectionStrategy) {
                this.downloadStrategyCbx.setSelectedIndex(2);
            } else if (strategy instanceof RandomScopeSelectionStrategy) {
                this.downloadStrategyCbx.setSelectedIndex(3);
            } else {
                NLogger.error(DownloadConfigDialog.class, (Object)("Unknown scope selection strategy: " + strategy.getClass().getName()));
            }
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean isInputValid() {
        String filename = this.fileNameTF.getText().trim();
        if (filename.length() == 0) {
            GUIUtils.showErrorMessage(this, Localizer.getString("ConfigDownload_ErrorNoFileName"));
            this.fileNameTF.requestFocus();
            return false;
        }
        String directoryStr = this.destDirectoryTF.getText().trim();
        if (filename.length() == 0) {
            GUIUtils.showErrorMessage(this, Localizer.getString("ConfigDownload_ErrorNoDestDir"));
            this.destDirectoryTF.requestFocus();
            return false;
        }
        File directory = new File(directoryStr);
        if (!directory.isAbsolute() || directory.exists() && !directory.isDirectory()) {
            GUIUtils.showErrorMessage(this, Localizer.getString("ConfigDownload_ErrorInvalidDestDir"));
            this.destDirectoryTF.requestFocus();
            return false;
        }
        if (!directory.exists() && !directory.mkdirs()) {
            GUIUtils.showErrorMessage(this, Localizer.getString("ConfigDownload_ErrorCreateDestDir"));
            this.destDirectoryTF.requestFocus();
            return false;
        }
        String researchTerm = this.searchTermTF.getText().trim();
        if (researchTerm.length() < 2) {
            Object[] objArr = new Object[]{2};
            GUIUtils.showErrorMessage(this, Localizer.getFormatedString("ConfigDownload_ErrorMinSearchTerm", objArr));
            this.searchTermTF.requestFocus();
            return false;
        }
        return true;
    }

    private void performChanges() {
        ScopeSelectionStrategy strategy;
        SwarmingManager swarmingMgr = Servent.getInstance().getDownloadService();
        String filename = this.fileNameTF.getText().trim();
        String directoryStr = this.destDirectoryTF.getText().trim();
        File destDir = new File(directoryStr);
        String researchTerm = this.searchTermTF.getText().trim();
        SWDownloadFile downloadFileToChange = null;
        if (this.remoteFile != null) {
            downloadFileToChange = swarmingMgr.addFileToDownload(this.remoteFile, FileUtils.convertToLocalSystemFilename(filename), researchTerm);
            this.remoteFile.setInDownloadQueue(true);
        } else if (this.downloadFile != null) {
            this.downloadFile.setFileName(filename);
            this.downloadFile.getResearchSetting().setSearchTerm(researchTerm);
            downloadFileToChange = this.downloadFile;
        } else {
            throw new RuntimeException("RemoteFile and DownloadFile is null");
        }
        downloadFileToChange.setDestinationDirectory(destDir);
        switch (this.downloadStrategyCbx.getSelectedIndex()) {
            case 0: {
                strategy = ScopeSelectionStrategyProvider.getAvailBeginRandSelectionStrategy();
                break;
            }
            case 1: {
                strategy = ScopeSelectionStrategyProvider.getBeginAvailRandSelectionStrategy();
                break;
            }
            case 2: {
                strategy = ScopeSelectionStrategyProvider.getBeginEndAvailRandSelectionStrategy();
                break;
            }
            case 3: {
                strategy = ScopeSelectionStrategyProvider.getRandomSelectionStrategy();
                break;
            }
            default: {
                NLogger.error(DownloadConfigDialog.class, (Object)("Unknown scope selection strategy index: " + this.downloadStrategyCbx.getSelectedIndex()));
                strategy = ScopeSelectionStrategyProvider.getAvailBeginRandSelectionStrategy();
            }
        }
        downloadFileToChange.getMemoryFile().setScopeSelectionStrategy(strategy);
        if (this.remoteFile != null) {
            if (this.topPriority.isSelected()) {
                swarmingMgr.moveDownloadFilePriority(downloadFileToChange, (short)0);
            } else if (this.bottomPriority.isSelected()) {
                swarmingMgr.moveDownloadFilePriority(downloadFileToChange, (short)3);
            }
        }
    }

    private final class BrowseDestDirBtnListener
    implements ActionListener {
        private BrowseDestDirBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File file = FileDialogHandler.openSingleDirectoryChooser(DownloadConfigDialog.this, Localizer.getString("ConfigDownload_SelectDestinationDirectory"), Localizer.getString("ConfigDownload_Select"), Localizer.getChar("ConfigDownload_SelectMnemonic"), new File(DownloadConfigDialog.this.destDirectoryTF.getText()));
                if (file != null) {
                    DownloadConfigDialog.this.destDirectoryTF.setText(file.getAbsolutePath());
                }
            }
            catch (Throwable th) {
                NLogger.error(BrowseDestDirBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class CancelBtnListener
    implements ActionListener {
        private CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DownloadConfigDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error(CancelBtnListener.class, (Object)th, th);
            }
        }
    }

    private final class OkBtnListener
    implements ActionListener {
        private OkBtnListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (DownloadConfigDialog.this.isInputValid()) {
                    DownloadConfigDialog.this.performChanges();
                    if (DownloadConfigDialog.this.switchToDownloadTab != null && DownloadConfigDialog.this.switchToDownloadTab.isSelected()) {
                        GUIRegistry.getInstance().getMainFrame().setSelectedTab(1003);
                    }
                    DownloadConfigDialog.this.closeDialog();
                }
            }
            catch (Throwable th) {
                NLogger.error(OkBtnListener.class, (Object)th, th);
            }
        }
    }
}

