/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import phex.common.log.NLogger;
import phex.gui.common.GUIRegistry;
import phex.gui.common.table.ColumnFactory;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTableColumn;
import phex.gui.common.table.FWTableColumnModel;
import phex.gui.renderer.DefaultPhexCellRenderers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FWTable
extends JTable {
    private ColumnFactory columnFactory;
    private int visibleRowCount = 18;
    private boolean isColumnResizeToFitEnabled = false;
    private boolean isColumnSortingEnabled = false;
    private JPopupMenu headerPopup;

    public FWTable(TableModel dataModel, FWTableColumnModel columnModel) {
        super(dataModel, columnModel);
        this.tableHeader.addMouseListener(new MouseHandler());
        DefaultPhexCellRenderers.setDefaultPhexCellRenderers(this);
    }

    public FWTable(TableModel dataModel) {
        this(dataModel, null);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        if (this.getModel() == null) {
            return;
        }
        this.removeColumns();
        this.createAndAddColumns();
    }

    private void createAndAddColumns() {
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            this.getColumnModel().addColumn(this.getColumnFactory().createAndConfigureTableColumn(this.getModel(), i));
        }
    }

    private void removeColumns() {
        List<TableColumn> columns = this.getColumns(true);
        Iterator<TableColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            this.getColumnModel().removeColumn(iter.next());
        }
    }

    public ColumnFactory getColumnFactory() {
        if (this.columnFactory == null) {
            return ColumnFactory.getInstance();
        }
        return this.columnFactory;
    }

    public void setColumnFactory(ColumnFactory columnFactory) {
        ColumnFactory old = this.getColumnFactory();
        this.columnFactory = columnFactory;
        this.firePropertyChange("columnFactory", old, this.getColumnFactory());
    }

    public void setVisibleRowCount(int count) {
        this.visibleRowCount = count;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension prefSize = super.getPreferredScrollableViewportSize();
        if (prefSize.getWidth() == 450.0 && prefSize.getHeight() == 400.0) {
            TableColumnModel columnModel = this.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            int w = 0;
            for (int i = 0; i < columnCount; ++i) {
                TableColumn column = columnModel.getColumn(i);
                w += column.getPreferredWidth();
            }
            prefSize.width = w;
            JTableHeader header = this.getTableHeader();
            int rowCount = this.getVisibleRowCount();
            prefSize.height = rowCount * this.getRowHeight() + (header != null ? header.getPreferredSize().height : 0);
            this.setPreferredScrollableViewportSize(prefSize);
        }
        return prefSize;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        GUIRegistry guiRegistry = GUIRegistry.getInstance();
        boolean showHorizontalLines = guiRegistry.getShowTableHorizontalLines();
        boolean showVerticalLines = guiRegistry.getShowTableVerticalLines();
        this.setShowHorizontalLines(showHorizontalLines);
        this.setShowVerticalLines(showVerticalLines);
        int intercellWidth = showVerticalLines ? 1 : 0;
        int intercellHeight = showHorizontalLines ? 1 : 0;
        this.setIntercellSpacing(new Dimension(intercellWidth, intercellHeight));
    }

    public void scrollRowToVisible(int row) {
        Rectangle cellRect = this.getCellRect(row, 0, false);
        Rectangle visibleRect = this.getVisibleRect();
        cellRect.x = visibleRect.x;
        cellRect.width = visibleRect.width;
        this.scrollRectToVisible(cellRect);
    }

    public static JScrollPane createFWTableScrollPane(JTable table) {
        JScrollPane tableScrollPane = new JScrollPane(table);
        FWTable.updateFWTableScrollPane(tableScrollPane);
        return tableScrollPane;
    }

    public static void updateFWTableScrollPane(JScrollPane tableScrollPane) {
        JViewport viewport = tableScrollPane.getViewport();
        if (viewport == null) {
            NLogger.error(FWTable.class, (Object)"tableScrollPane.getViewport() returns null");
            return;
        }
        viewport.setOpaque(true);
        Color color = (Color)UIManager.getDefaults().get("window");
        if (color != null) {
            Color newColor = new Color(color.getRGB());
            viewport.setBackground(newColor);
        } else {
            NLogger.error(FWTable.class, (Object)"UIManager.getDefaults.get( \"window\" ) returns null");
        }
    }

    public void activateAllHeaderActions() {
        this.activateHeaderPopupMenu();
        this.activateColumnResizeToFit();
        this.activateColumnSorting();
    }

    public void activateColumnSorting() {
        this.setColumnSelectionAllowed(false);
        this.isColumnSortingEnabled = true;
        FWSortedTableModel sortedModel = (FWSortedTableModel)this.dataModel;
        sortedModel.setTableHeader(this.tableHeader);
    }

    public TableColumn getColumn(int viewColumnIndex) {
        return this.getColumnModel().getColumn(viewColumnIndex);
    }

    public List<TableColumn> getColumns() {
        return Collections.list(this.getColumnModel().getColumns());
    }

    public int getColumnMargin() {
        return this.getColumnModel().getColumnMargin();
    }

    public void setColumnMargin(int value) {
        this.getColumnModel().setColumnMargin(value);
    }

    public int getColumnCount(boolean includeHidden) {
        if (this.getColumnModel() instanceof FWTableColumnModel) {
            return ((FWTableColumnModel)this.getColumnModel()).getColumnCount(includeHidden);
        }
        return this.getColumnCount();
    }

    public List<TableColumn> getColumns(boolean includeHidden) {
        if (this.getColumnModel() instanceof FWTableColumnModel) {
            return ((FWTableColumnModel)this.getColumnModel()).getColumns(includeHidden);
        }
        return this.getColumns();
    }

    public FWTableColumn getFWColumn(Object identifier) {
        if (this.getColumnModel() instanceof FWTableColumnModel) {
            return ((FWTableColumnModel)this.getColumnModel()).getFWColumn(identifier);
        }
        try {
            TableColumn column = this.getColumn(identifier);
            if (column instanceof FWTableColumn) {
                return (FWTableColumn)column;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public FWTableColumn getFWColumn(int viewColumnIndex) {
        TableColumn column = this.getColumn(viewColumnIndex);
        if (column instanceof FWTableColumn) {
            return (FWTableColumn)column;
        }
        return null;
    }

    protected boolean isUpdate(TableModelEvent e) {
        if (this.isStructureChanged(e)) {
            return false;
        }
        return e.getType() == 0 && e.getLastRow() < Integer.MAX_VALUE;
    }

    protected boolean isStructureChanged(TableModelEvent e) {
        return e == null || e.getFirstRow() == -1;
    }

    public void activateColumnResizeToFit() {
        this.isColumnResizeToFitEnabled = true;
    }

    public void activateHeaderPopupMenu() {
        this.headerPopup = new JPopupMenu();
        PopupMenuActionHandler actionHandler = new PopupMenuActionHandler();
        List<TableColumn> colList = ((FWTableColumnModel)this.columnModel).getColumns(true);
        for (TableColumn column : colList) {
            if (!(column instanceof FWTableColumn)) continue;
            FWTableColumn fwColumn = (FWTableColumn)column;
            ColumnCheckBoxMenuItem chkItem = new ColumnCheckBoxMenuItem(fwColumn);
            chkItem.setEnabled(fwColumn.isHideable());
            chkItem.addActionListener(actionHandler);
            this.headerPopup.add(chkItem);
        }
    }

    public int translateRowIndexToModel(int viewRowIndex) {
        if (this.isColumnSortingEnabled) {
            return ((FWSortedTableModel)this.dataModel).getModelIndex(viewRowIndex);
        }
        return viewRowIndex;
    }

    public int[] convertRowIndicesToModel(int[] viewRowIndices) {
        if (this.isColumnSortingEnabled) {
            FWSortedTableModel sortedModel = (FWSortedTableModel)this.dataModel;
            int[] modelRowIndices = new int[viewRowIndices.length];
            for (int i = 0; i < viewRowIndices.length; ++i) {
                modelRowIndices[i] = sortedModel.getModelIndex(viewRowIndices[i]);
            }
            return modelRowIndices;
        }
        return viewRowIndices;
    }

    public int translateRowIndexToView(int modelRowIndex) {
        if (this.isColumnSortingEnabled) {
            return ((FWSortedTableModel)this.dataModel).getViewIndex(modelRowIndex);
        }
        return modelRowIndex;
    }

    public FWTableColumn getResizingColumn(Point p) {
        int columnIndex;
        int column = this.tableHeader.columnAtPoint(p);
        if (column == -1) {
            return null;
        }
        Rectangle r = this.tableHeader.getHeaderRect(column);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int midPoint = r.x + r.width / 2;
        if (this.tableHeader.getComponentOrientation().isLeftToRight()) {
            columnIndex = p.x < midPoint ? column - 1 : column;
        } else {
            int n = columnIndex = p.x < midPoint ? column : column - 1;
        }
        if (columnIndex == -1) {
            return null;
        }
        return (FWTableColumn)this.tableHeader.getColumnModel().getColumn(columnIndex);
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new FWTableColumnModel();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        Rectangle dirtyRegion;
        if (e == null || e.getFirstRow() == -1) {
            super.tableChanged(e);
            return;
        }
        if (e.getType() == 1 || e.getType() == -1) {
            super.tableChanged(e);
            return;
        }
        super.tableChanged(e);
        int modelColumn = e.getColumn();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (modelColumn == -1) {
            dirtyRegion = new Rectangle(0, start * this.getRowHeight(), this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int column = this.convertColumnIndexToView(modelColumn);
            dirtyRegion = this.getCellRect(start, column, false);
        }
        if (end != Integer.MAX_VALUE) {
            dirtyRegion.height = (end - start + 1) * this.getRowHeight();
            this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
        } else {
            this.resizeAndRepaint();
        }
    }

    private class ColumnCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private FWTableColumn column;

        public ColumnCheckBoxMenuItem(FWTableColumn tableColumn) {
            super((String)tableColumn.getHeaderValue(), tableColumn.isVisible());
            this.column = tableColumn;
        }

        public FWTableColumn getTableColumn() {
            return this.column;
        }
    }

    private class PopupMenuActionHandler
    implements ActionListener {
        private PopupMenuActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            ColumnCheckBoxMenuItem item = (ColumnCheckBoxMenuItem)e.getSource();
            FWTableColumn column = item.getTableColumn();
            if (item.getState()) {
                column.setVisible(true);
            } else {
                column.setVisible(false);
            }
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            FWTableColumn column = FWTable.this.getResizingColumn(e.getPoint());
            int clickCount = e.getClickCount();
            if (clickCount >= 2) {
                this.handleColumnResizeToFit(column);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void handleColumnResizeToFit(FWTableColumn column) {
            if (!FWTable.this.isColumnResizeToFitEnabled) {
                return;
            }
            if (column != null) {
                column.sizeWidthToFitData(FWTable.this, FWTable.this.dataModel);
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (FWTable.this.headerPopup != null) {
                FWTable.this.headerPopup.show(source, x, y);
            }
        }
    }
}

