/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import phex.common.log.NLogger;
import phex.download.DownloadConnection;
import phex.download.FileNotAvailableException;
import phex.download.HostBusyException;
import phex.download.RangeUnavailableException;
import phex.download.ReconnectException;
import phex.download.RemotelyQueuedException;
import phex.download.ThexVerificationData;
import phex.download.handler.DownloadHandler;
import phex.download.handler.DownloadHandlerException;
import phex.download.handler.HttpFileDownload;
import phex.download.handler.HttpThexDownload;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSet;
import phex.host.UnusableHostException;
import phex.http.HTTPMessageException;
import phex.net.connection.Connection;

public class DownloadEngine {
    private Status status;
    private Connection connection;
    private SWDownloadSet downloadSet;
    private DownloadHandler downloadHandler;

    public DownloadEngine(SWDownloadSet downloadSet) {
        this.downloadSet = downloadSet;
        this.status = Status.RUNNING;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public SWDownloadSet getDownloadSet() {
        return this.downloadSet;
    }

    public void setConnection(DownloadConnection connection) {
        this.connection = connection;
        assert (this.status == Status.RUNNING) : "This DownloadEngine has an invalid status: " + (Object)((Object)this.status);
    }

    public void abortDownload() {
        this.status = Status.ABORTED;
        SWDownloadCandidate candidate = this.downloadSet.getCandidate();
        candidate.addToCandidateLog("Download aborted.");
        this.stopInternalDownload();
    }

    private void failDownload() {
        this.status = Status.FAILED;
        SWDownloadCandidate candidate = this.downloadSet.getCandidate();
        candidate.addToCandidateLog("Download failed.");
        this.stopInternalDownload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEngine() {
        try {
            SWDownloadCandidate candidate = this.downloadSet.getCandidate();
            SWDownloadFile downloadFile = this.downloadSet.getDownloadFile();
            do {
                this.processRequest();
            } while (this.status == Status.RUNNING && this.downloadHandler.isAcceptingNextRequest() && downloadFile.isScopeAllocateable(candidate.getAvailableScopeList()));
            if (candidate.getStatus() == SWDownloadCandidate.CandidateStatus.CONNECTING || candidate.getStatus() == SWDownloadCandidate.CandidateStatus.DOWNLOADING || candidate.getStatus() == SWDownloadCandidate.CandidateStatus.PUSH_REQUEST || candidate.getStatus() == SWDownloadCandidate.CandidateStatus.REQUESTING) {
                candidate.setStatus(SWDownloadCandidate.CandidateStatus.WAITING);
            }
        }
        finally {
            this.status = Status.FINISHED;
            this.stopInternalDownload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest() {
        SWDownloadCandidate candidate = this.downloadSet.getCandidate();
        SWDownloadFile downloadFile = this.downloadSet.getDownloadFile();
        try {
            do {
                this.initDownloadHandler();
                if (this.status != Status.RUNNING) {
                    return;
                }
                this.processDownloadHandlerHandshake();
                if (this.status != Status.RUNNING) {
                    return;
                }
                this.holdPossibleQueueState();
                if (this.status == Status.RUNNING) continue;
                return;
            } while (candidate.isRemotlyQueued() || candidate.isRangeUnavailable());
            downloadFile.removeQueuedCandidate(candidate);
            downloadFile.setStatus(2);
            candidate.setStatus(SWDownloadCandidate.CandidateStatus.DOWNLOADING);
            try {
                this.downloadHandler.processDownload();
            }
            catch (MalformedURLException exp) {
                this.failDownload();
                candidate.addToCandidateLog(exp);
                candidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
                NLogger.error(DownloadEngine.class, (Object)("Error at Host: " + candidate.getHostAddress() + " Vendor: " + candidate.getVendor()), (Throwable)exp);
            }
            catch (IOException exp) {
                this.failDownload();
                candidate.addToCandidateLog(exp.toString());
                candidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
                NLogger.warn(DownloadEngine.class, (Object)("Error at Host: " + candidate.getHostAddress() + " Vendor: " + candidate.getVendor()), (Throwable)exp);
            }
        }
        finally {
            if (this.downloadHandler != null) {
                this.downloadHandler.postProcess();
            }
        }
    }

    private void initDownloadHandler() {
        this.downloadHandler = this.possiblyInitThexHandler();
        if (this.downloadHandler == null) {
            this.downloadHandler = new HttpFileDownload(this);
        }
        try {
            this.downloadHandler.preProcess();
        }
        catch (DownloadHandlerException exp) {
            SWDownloadCandidate candidate = this.downloadSet.getCandidate();
            candidate.addToCandidateLog("No segment to allocate.");
            this.failDownload();
        }
    }

    private void processDownloadHandlerHandshake() {
        NLogger.debug(DownloadEngine.class, (Object)("process handshake with: " + this.downloadSet + " - " + this));
        SWDownloadCandidate downloadCandidate = this.downloadSet.getCandidate();
        try {
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.REQUESTING);
            this.downloadHandler.processHandshake();
        }
        catch (RemotelyQueuedException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            downloadCandidate.updateXQueueParameters(exp.getXQueueParameters());
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.REMOTLY_QUEUED);
        }
        catch (ReconnectException exp) {
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug(DownloadEngine.class, (Object)(downloadCandidate + " " + exp.getMessage()));
            this.failDownload();
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.WAITING);
        }
        catch (RangeUnavailableException exp) {
            boolean isScopeListAvailable;
            SWDownloadFile downloadFile = this.downloadSet.getDownloadFile();
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug(DownloadEngine.class, (Object)(exp.toString() + " :: " + downloadCandidate));
            boolean bl = isScopeListAvailable = downloadCandidate.getAvailableScopeList() != null && downloadCandidate.getAvailableScopeList().size() > 0;
            if (isScopeListAvailable && downloadFile.isScopeAllocateable(downloadCandidate.getAvailableScopeList())) {
                downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.RANGE_UNAVAILABLE);
            } else {
                this.failDownload();
                int waitTime = exp.getWaitTimeInSeconds() > 0 ? exp.getWaitTimeInSeconds() : -1;
                downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.RANGE_UNAVAILABLE, waitTime);
            }
        }
        catch (HostBusyException exp) {
            this.failDownload();
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.BUSY, exp.getWaitTimeInSeconds());
            NLogger.debug(DownloadEngine.class, (Object)(downloadCandidate + " " + exp.getMessage()));
        }
        catch (UnusableHostException exp) {
            this.failDownload();
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.debug(DownloadEngine.class, (Object)exp, (Throwable)exp);
            NLogger.debug(DownloadEngine.class, (Object)("Removing download candidate: " + downloadCandidate));
            SWDownloadFile downloadFile = this.downloadSet.getDownloadFile();
            if (exp instanceof FileNotAvailableException) {
                downloadFile.markCandidateIgnored(downloadCandidate, "CandidateStatusReason_FileNotFound");
            } else {
                downloadFile.markCandidateIgnored(downloadCandidate, "CandidateStatusReason_Unusable");
            }
            downloadFile.addBadAltLoc(downloadCandidate);
        }
        catch (HTTPMessageException exp) {
            this.failDownload();
            downloadCandidate.addToCandidateLog(exp.toString());
            NLogger.warn(DownloadEngine.class, (Object)exp, (Throwable)exp);
        }
        catch (SocketTimeoutException exp) {
            this.failDownload();
            downloadCandidate.addToCandidateLog(exp.toString());
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            NLogger.debug(DownloadEngine.class, (Object)exp, (Throwable)exp);
        }
        catch (SocketException exp) {
            this.failDownload();
            downloadCandidate.addToCandidateLog(exp.toString());
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            NLogger.debug(DownloadEngine.class, (Object)exp, (Throwable)exp);
        }
        catch (IOException exp) {
            this.failDownload();
            downloadCandidate.addToCandidateLog(exp.toString());
            downloadCandidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
            NLogger.warn(DownloadEngine.class, (Object)("Error at Host: " + downloadCandidate.getHostAddress() + " Vendor: " + downloadCandidate.getVendor()), (Throwable)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadHandler possiblyInitThexHandler() {
        ThexVerificationData thexVerif;
        SWDownloadFile downloadFile = this.downloadSet.getDownloadFile();
        if (downloadFile.getFileURN() == null) {
            return null;
        }
        if (!this.downloadSet.getCandidate().isThexSupported()) {
            return null;
        }
        ThexVerificationData thexVerificationData = thexVerif = downloadFile.getThexVerificationData();
        synchronized (thexVerificationData) {
            if (thexVerif.isThexRequested()) {
                return null;
            }
            ThexVerificationData.ThexData thexData = thexVerif.getThexData();
            if (thexData != null && thexData.isGoodQuality()) {
                return null;
            }
            thexVerif.setThexRequested(true);
            HttpThexDownload handler = new HttpThexDownload(this, thexVerif);
            return handler;
        }
    }

    private void holdPossibleQueueState() {
        SWDownloadCandidate candidate = this.downloadSet.getCandidate();
        if (!candidate.isRemotlyQueued()) {
            return;
        }
        SWDownloadFile downloadFile = this.downloadSet.getDownloadFile();
        boolean succ = downloadFile.addAndValidateQueuedCandidate(candidate);
        if (!succ) {
            this.failDownload();
            return;
        }
        try {
            int sleepTime = candidate.getXQueueParameters().getRequestSleepTime();
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException exp) {
            NLogger.debug(DownloadEngine.class, (Object)"Interrupted Worker sleeping for queue.");
            this.failDownload();
            candidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTION_FAILED);
        }
    }

    private void stopInternalDownload() {
        if (this.downloadHandler != null) {
            this.downloadHandler.stopDownload();
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        RUNNING,
        FINISHED,
        FAILED,
        ABORTED;

    }
}

