/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import phex.download.DownloadDataWriter;

public class BufferVolumeTracker {
    private final BufferVolumeTracker parent;
    private final Sync sync;
    private final DownloadDataWriter dataWriter;

    public BufferVolumeTracker(int maxBufferSize, DownloadDataWriter dataWriter) {
        this(null, maxBufferSize, dataWriter);
    }

    public BufferVolumeTracker(BufferVolumeTracker parent, int maxBufferSize, DownloadDataWriter dataWriter) {
        this.parent = parent;
        this.dataWriter = dataWriter;
        this.sync = new Sync(maxBufferSize);
    }

    public int getUsedBufferSize() {
        return this.sync.getUsedStates();
    }

    public int getFreeBufferSize() {
        return this.sync.getFreeStates();
    }

    public void addBufferedSize(int amount) {
        if (this.parent != null) {
            this.parent.addBufferedSize(amount);
        }
        this.sync.acquireShared(amount);
    }

    public void reduceBufferedSize(int amount) {
        if (this.parent != null) {
            this.parent.reduceBufferedSize(amount);
        }
        this.sync.releaseShared(amount);
    }

    class Sync
    extends AbstractQueuedSynchronizer {
        private int currentMax;

        Sync(int max) {
            this.currentMax = max;
            this.setState(max);
        }

        public int getUsedStates() {
            return this.currentMax - this.getState();
        }

        public int getFreeStates() {
            return this.getState();
        }

        protected final int tryAcquireShared(int acquires) {
            int remaining;
            int available;
            do {
                if ((remaining = (available = this.getState()) - acquires) >= 0) continue;
                BufferVolumeTracker.this.dataWriter.triggerWriteCycle();
                return remaining;
            } while (!this.compareAndSetState(available, remaining));
            return remaining;
        }

        protected final boolean tryReleaseShared(int releases) {
            int p;
            while (!this.compareAndSetState(p = this.getState(), p + releases)) {
            }
            return true;
        }
    }
}

