/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import java.io.IOException;
import phex.common.log.NLogger;
import phex.connection.ConnectionConstants;
import phex.connection.ProtocolNotSupportedException;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPProcessor;
import phex.net.connection.Connection;
import phex.prefs.core.ConnectionPrefs;

public class HandshakeStatus
implements ConnectionConstants {
    private int statusCode;
    private String statusMessage;
    private HTTPHeaderGroup responseHeaders;

    public HandshakeStatus(int statusCode, String statusMessage) {
        this(statusCode, statusMessage, HTTPHeaderGroup.EMPTY_HEADERGROUP);
    }

    public HandshakeStatus(int statusCode, String statusMessage, HTTPHeaderGroup responseHeaders) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.responseHeaders = responseHeaders;
    }

    public HandshakeStatus(HTTPHeaderGroup responseHeaders) {
        this(200, "OK", responseHeaders);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public HTTPHeaderGroup getResponseHeaders() {
        return this.responseHeaders;
    }

    public boolean isDeflateAccepted() {
        return ConnectionPrefs.AcceptDeflateConnection.get() != false && this.responseHeaders.isHeaderValueContaining("Accept-Encoding", "deflate");
    }

    public static HandshakeStatus parseHandshakeResponse(Connection connection) throws ProtocolNotSupportedException, IOException {
        String statusMessage;
        int statusCode;
        String response = connection.readLine();
        if (response == null) {
            throw new IOException("Disconnected from remote host during initial handshake");
        }
        if (!response.startsWith("GNUTELLA/0.6")) {
            throw new ProtocolNotSupportedException("Bad protocol response: " + response);
        }
        HTTPHeaderGroup responseHeaders = HTTPProcessor.parseHTTPHeaders(connection);
        try {
            String statusString = response.substring("GNUTELLA/0.6".length()).trim();
            int statusMsgIdx = statusString.indexOf(32);
            if (statusMsgIdx == -1) {
                statusMsgIdx = statusString.length();
            }
            statusCode = Integer.parseInt(statusString.substring(0, statusMsgIdx));
            statusMessage = statusString.substring(statusMsgIdx).trim();
        }
        catch (Exception exp) {
            NLogger.warn(HandshakeStatus.class, (Object)("Error parsing response: '" + response + "'."), (Throwable)exp);
            throw new IOException("Error parsing response: '" + response + "': " + exp);
        }
        return new HandshakeStatus(statusCode, statusMessage, responseHeaders);
    }
}

