/*
 * Decompiled with CFR 0.152.
 */
package phex.common.log;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import phex.common.Environment;
import phex.utils.VersionUtils;

public class PhexLogger
implements Log {
    public static final LogLevel DEBUG = new LogLevel(0);
    public static final LogLevel INFO = new LogLevel(1);
    public static final LogLevel WARN = new LogLevel(2);
    public static final LogLevel ERROR = new LogLevel(3);
    private static String[] verboseLevelName = new String[]{"Debug", "Info", "Warn", "Error"};
    private static short logLevelValue = PhexLogger.ERROR.value;
    private static boolean logToConsole = false;
    private static File logFile;
    private static File errorLogFile;
    private static PrintWriter logWriter;
    private static DateFormat dateFormat;
    private static Date date;
    private static long maxLogFileLength;
    private String loggerName;

    public PhexLogger() {
    }

    public PhexLogger(String name) {
        this.loggerName = name;
    }

    public boolean isDebugEnabled() {
        return PhexLogger.isLevelLogged(DEBUG);
    }

    public boolean isErrorEnabled() {
        return PhexLogger.isLevelLogged(ERROR);
    }

    public boolean isFatalEnabled() {
        return PhexLogger.isLevelLogged(ERROR);
    }

    public boolean isInfoEnabled() {
        return PhexLogger.isLevelLogged(INFO);
    }

    public boolean isTraceEnabled() {
        return PhexLogger.isLevelLogged(DEBUG);
    }

    public boolean isWarnEnabled() {
        return PhexLogger.isLevelLogged(WARN);
    }

    public void trace(Object message) {
        this.debug(message);
    }

    public void trace(Object message, Throwable t) {
        this.debug(message, t);
    }

    public void debug(Object message) {
        if (PhexLogger.isLevelLogged(DEBUG)) {
            this.writeLogMessage(DEBUG, message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (PhexLogger.isLevelLogged(DEBUG)) {
            this.writeLogMessage(DEBUG, message, t);
        }
    }

    public void info(Object message) {
        if (PhexLogger.isLevelLogged(INFO)) {
            this.writeLogMessage(INFO, message, null);
        }
    }

    public void info(Object message, Throwable t) {
        if (PhexLogger.isLevelLogged(INFO)) {
            this.writeLogMessage(INFO, message, t);
        }
    }

    public void warn(Object message) {
        if (PhexLogger.isLevelLogged(WARN)) {
            this.writeLogMessage(WARN, message, null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (PhexLogger.isLevelLogged(WARN)) {
            this.writeLogMessage(WARN, message, t);
        }
    }

    public void error(Object message) {
        if (PhexLogger.isLevelLogged(ERROR)) {
            this.writeLogMessage(ERROR, message, null);
        }
    }

    public void error(Object message, Throwable t) {
        if (PhexLogger.isLevelLogged(ERROR)) {
            this.writeLogMessage(ERROR, message, t);
        }
    }

    public void fatal(Object message) {
        this.error(message);
    }

    public void fatal(Object message, Throwable t) {
        this.error(message, t);
    }

    private static boolean isLevelLogged(LogLevel aLogLevel) {
        return logLevelValue <= aLogLevel.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogMessage(LogLevel aVerboseLevel, Object message, Throwable throwable) {
        String msgText = message != null ? message.toString() : "";
        StringBuffer buffer = new StringBuffer(40 + msgText.length());
        buffer.append(PhexLogger.getTimeString());
        buffer.append("(");
        try {
            buffer.append(VersionUtils.getBuild());
        }
        catch (Exception exp) {
            buffer.append("-");
        }
        buffer.append(")");
        buffer.append(" ");
        buffer.append(PhexLogger.getLogLevelName(aVerboseLevel));
        buffer.append("/");
        buffer.append(this.loggerName);
        buffer.append(":: ");
        buffer.append(message);
        if (throwable != null) {
            String stackTrace = PhexLogger.getStackTrace(throwable);
            buffer.append(" - Exception: ");
            buffer.append(stackTrace);
        }
        if (logToConsole) {
            if (aVerboseLevel.value >= PhexLogger.ERROR.value) {
                System.err.println(buffer.toString());
            } else {
                System.out.println(buffer.toString());
            }
        }
        Class<PhexLogger> clazz = PhexLogger.class;
        synchronized (PhexLogger.class) {
            PhexLogger.initLogFileWriter();
            logWriter.println(buffer.toString());
            if (logFile != null && logFile.length() > maxLogFileLength) {
                logWriter.close();
                logWriter = null;
                File tmpFile = new File(logFile.getAbsolutePath() + ".1");
                tmpFile.delete();
                logFile.renameTo(tmpFile);
            }
            if (aVerboseLevel.value >= PhexLogger.ERROR.value) {
                try {
                    PrintWriter errorLogWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(errorLogFile.getPath(), true)), true);
                    errorLogWriter.println(buffer.toString());
                    errorLogWriter.close();
                    if (errorLogFile.length() > maxLogFileLength) {
                        File tmpFile = new File(errorLogFile.getAbsolutePath() + ".1");
                        tmpFile.delete();
                        errorLogFile.renameTo(tmpFile);
                    }
                }
                catch (IOException exp) {
                    exp.printStackTrace();
                }
            }
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTimeString() {
        if (dateFormat == null) {
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyMMdd HH:mm:ss,SSSS");
            dateFormat = sDateFormat;
        }
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        } else {
            date.setTime(System.currentTimeMillis());
        }
        DateFormat dateFormat = PhexLogger.dateFormat;
        synchronized (dateFormat) {
            return PhexLogger.dateFormat.format(date);
        }
    }

    private static String getLogLevelName(LogLevel logLevel) {
        if (logLevel.value >= 0 && logLevel.value < verboseLevelName.length) {
            return verboseLevelName[logLevel.value];
        }
        return "Unknwon (" + logLevel.value + ')';
    }

    public static void setLogToConsole(boolean state) {
        logToConsole = state;
    }

    public static void setMaxLogFileLength(long byteLength) {
        maxLogFileLength = byteLength;
    }

    public static void setVerboseLevel(short newLogLevelValue) {
        if (newLogLevelValue >= PhexLogger.DEBUG.value && newLogLevelValue <= PhexLogger.ERROR.value) {
            logLevelValue = newLogLevelValue;
        }
    }

    public static synchronized void setLogFile(File file) {
        logFile = file;
        logWriter = null;
    }

    public static void setErrorLogFile(File file) {
        errorLogFile = file;
    }

    private static synchronized void initLogFileWriter() {
        if (logWriter != null) {
            return;
        }
        if (logFile != null) {
            logFile.getParentFile().mkdirs();
            try {
                logWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(logFile.getPath(), true)), true);
            }
            catch (IOException exp) {
                exp.printStackTrace();
            }
        } else {
            logToConsole = false;
            logWriter = new PrintWriter(System.out, true);
        }
        if (errorLogFile != null) {
            errorLogFile.getParentFile().mkdirs();
        }
    }

    private static String getStackTrace(Throwable aThrowable) {
        CharArrayWriter buffer = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(buffer);
        while (aThrowable != null) {
            aThrowable.printStackTrace(printWriter);
            if (aThrowable instanceof InvocationTargetException) {
                aThrowable = ((InvocationTargetException)aThrowable).getTargetException();
                continue;
            }
            aThrowable = null;
        }
        return buffer.toString();
    }

    static {
        String logFileName = System.getProperty("phex.utils.logger.logFile", "phex.log");
        PhexLogger.setLogFile(Environment.getInstance().getPhexConfigFile(logFileName));
        String errorLogFileName = System.getProperty("phex.utils.logger.errorLogFile", "phex.error.log");
        PhexLogger.setErrorLogFile(Environment.getInstance().getPhexConfigFile(errorLogFileName));
        String logToConsoleStr = System.getProperty("phex.utils.logger.console", "false");
        PhexLogger.setLogToConsole("true".equalsIgnoreCase(logToConsoleStr));
        String verboseLevel = System.getProperty("phex.utils.logger.level", "3");
        try {
            PhexLogger.setVerboseLevel(Short.parseShort(verboseLevel));
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
        String maxFileSize = System.getProperty("phex.utils.logger.maxFileSize", "524288");
        try {
            PhexLogger.setMaxLogFileLength(Long.parseLong(maxFileSize));
        }
        catch (NumberFormatException exp) {
            // empty catch block
        }
    }

    private static final class LogLevel {
        public final short value;

        public LogLevel(short aLevel) {
            this.value = aLevel;
        }
    }
}

