/*
 * Decompiled with CFR 0.152.
 */
package phex.common.log;

import java.util.Collection;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import phex.common.log.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogBuffer {
    private UnboundedFifoBuffer buffer;
    private MultiHashMap ownerMap;
    private long totalSize;
    private long maxSize;

    public LogBuffer(long maxSize) {
        this.maxSize = maxSize;
        this.totalSize = 0L;
        this.buffer = new UnboundedFifoBuffer();
        this.ownerMap = new MultiHashMap();
    }

    public void addLogRecord(LogRecord record) {
        int size = record.getSize();
        this.buffer.add((Object)record);
        this.ownerMap.put(record.getOwner(), (Object)record);
        this.totalSize += (long)size;
        this.validateBufferSize();
    }

    public Collection<LogRecord> getLogRecords(Object owner) {
        return this.ownerMap.getCollection(owner);
    }

    private void validateBufferSize() {
        while (this.totalSize > this.maxSize) {
            LogRecord record = (LogRecord)this.buffer.remove();
            this.ownerMap.remove(record.getOwner(), (Object)record);
            this.totalSize -= (long)record.getSize();
        }
    }

    public long getFillSize() {
        return this.totalSize;
    }

    public long getElementCount() {
        return this.buffer.size();
    }
}

