/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import phex.common.bandwidth.BandwidthController;
import phex.prefs.core.BandwidthPrefs;

public class BandwidthManager {
    private BandwidthController serventBandwidthController = new BandwidthController("ServentThrottle", BandwidthPrefs.MaxTotalBandwidth.get().intValue());
    private BandwidthController networkBandwidthController;
    private BandwidthController downloadBandwidthController;
    private BandwidthController uploadBandwidthController;

    public BandwidthManager() {
        this.serventBandwidthController.activateShortTransferAvg(1000, 5);
        this.serventBandwidthController.activateLongTransferAvg(2000, 90);
        this.networkBandwidthController = new BandwidthController("NetworkThrottle", BandwidthPrefs.MaxNetworkBandwidth.get().intValue(), this.serventBandwidthController);
        this.networkBandwidthController.activateShortTransferAvg(1000, 5);
        this.networkBandwidthController.activateLongTransferAvg(2000, 90);
        this.downloadBandwidthController = new BandwidthController("DownloadThrottle", BandwidthPrefs.MaxDownloadBandwidth.get().intValue(), this.serventBandwidthController);
        this.downloadBandwidthController.activateShortTransferAvg(1000, 5);
        this.downloadBandwidthController.activateLongTransferAvg(2000, 90);
        this.uploadBandwidthController = new BandwidthController("UploadThrottle", BandwidthPrefs.MaxUploadBandwidth.get().intValue(), this.serventBandwidthController);
        this.uploadBandwidthController.activateShortTransferAvg(1000, 5);
        this.uploadBandwidthController.activateLongTransferAvg(2000, 90);
    }

    public void setDownloadBandwidth(int newDownloadBwInBytes) {
        BandwidthPrefs.MaxDownloadBandwidth.set(newDownloadBwInBytes);
        this.downloadBandwidthController.setThrottlingRate(newDownloadBwInBytes);
    }

    public void setNetworkBandwidth(int newNetworkBwInBytes) {
        BandwidthPrefs.MaxNetworkBandwidth.set(newNetworkBwInBytes);
        this.networkBandwidthController.setThrottlingRate(newNetworkBwInBytes);
    }

    public void setServentBandwidth(int newPhexBwInBytes) {
        BandwidthPrefs.MaxTotalBandwidth.set(newPhexBwInBytes);
        this.serventBandwidthController.setThrottlingRate(newPhexBwInBytes);
    }

    public void setUploadBandwidth(int newUploadBwInBytes) {
        BandwidthPrefs.MaxUploadBandwidth.set(newUploadBwInBytes);
        this.uploadBandwidthController.setThrottlingRate(newUploadBwInBytes);
    }

    public BandwidthController getServentBandwidthController() {
        return this.serventBandwidthController;
    }

    public BandwidthController getNetworkBandwidthController() {
        return this.networkBandwidthController;
    }

    public BandwidthController getDownloadBandwidthController() {
        return this.downloadBandwidthController;
    }

    public BandwidthController getUploadBandwidthController() {
        return this.uploadBandwidthController;
    }
}

