/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import java.io.IOException;
import phex.common.bandwidth.TransferAverage;
import phex.common.log.NLogger;

public class BandwidthController {
    private static final int WINDOWS_PER_SECONDS = 5;
    private static final int MILLIS_PER_WINDOW = 200;
    private int bytesPerWindow;
    private int bytesRemaining;
    private long lastWindowTime;
    private long throttlingRate;
    private final String controllerName;
    private final BandwidthController nextContollerInChain;
    private TransferAverage shortTransferAvg;
    private TransferAverage longTransferAvg;

    public BandwidthController(String controllerName, long throttlingRate) {
        this(controllerName, throttlingRate, null);
    }

    public BandwidthController(String controllerName, long throttlingRate, BandwidthController parent) {
        this.controllerName = controllerName + " " + Integer.toHexString(this.hashCode());
        this.setThrottlingRate(throttlingRate);
        this.nextContollerInChain = parent;
        this.bytesRemaining = this.bytesPerWindow;
    }

    public synchronized void activateShortTransferAvg(int refreshRate, int period) {
        this.shortTransferAvg = new TransferAverage(refreshRate, period);
    }

    public synchronized void activateLongTransferAvg(int refreshRate, int period) {
        this.longTransferAvg = new TransferAverage(refreshRate, period);
    }

    public synchronized TransferAverage getShortTransferAvg() {
        return this.shortTransferAvg;
    }

    public synchronized TransferAverage getLongTransferAvg() {
        return this.longTransferAvg;
    }

    public synchronized void setThrottlingRate(long bytesPerSecond) {
        if (bytesPerSecond == this.throttlingRate) {
            return;
        }
        this.throttlingRate = bytesPerSecond;
        this.bytesPerWindow = Math.max((int)((double)this.throttlingRate / 5.0), 1);
        if (NLogger.isDebugEnabled(BandwidthController.class)) {
            NLogger.debug(BandwidthController.class, (Object)("[" + this.controllerName + "] Set throttling rate to " + bytesPerSecond + "bps (" + this.bytesPerWindow + " per window)"));
        }
        this.bytesRemaining = this.bytesRemaining < this.bytesPerWindow ? Math.min(this.bytesRemaining, this.bytesPerWindow) : this.bytesRemaining;
    }

    public synchronized long getThrottlingRate() {
        return this.throttlingRate;
    }

    public synchronized int getAvailableByteCount(int maxToRequest, boolean blockTillAvailable, boolean markBytesUsed) throws IOException {
        this.updateWindow(blockTillAvailable);
        int bytesAllowed = Math.max(0, Math.min(maxToRequest, this.bytesRemaining));
        if (this.nextContollerInChain != null) {
            bytesAllowed = this.nextContollerInChain.getAvailableByteCount(bytesAllowed, blockTillAvailable, markBytesUsed);
        }
        if (markBytesUsed) {
            this.markBytesUsed(bytesAllowed);
        }
        short logLevel = 1;
        if (this.bytesRemaining < 0) {
            logLevel = 4;
        }
        if (NLogger.isEnabled(logLevel, BandwidthController.class)) {
            NLogger.log(logLevel, BandwidthController.class, "[" + this.controllerName + "] Available byte count " + bytesAllowed + "bps - Remaining: " + this.bytesRemaining + ".");
        }
        return bytesAllowed;
    }

    public synchronized void markBytesUsed(int byteCount) throws IOException {
        assert (byteCount >= 0) : "Cant mark negative byteCount used: " + byteCount;
        this.updateWindow(false);
        this.bytesRemaining -= byteCount;
        if (this.bytesRemaining < 0) {
            this.bytesRemaining = Math.max(this.bytesRemaining, -75 * this.bytesPerWindow);
            this.updateWindow(true);
        }
        short logLevel = 1;
        if (this.bytesRemaining < 0) {
            logLevel = 4;
        }
        if (NLogger.isEnabled(logLevel, BandwidthController.class)) {
            NLogger.log(logLevel, BandwidthController.class, "[" + this.controllerName + "] !Mark bytes used " + byteCount + " - remaining: " + this.bytesRemaining + ".");
        }
        if (this.shortTransferAvg != null) {
            this.shortTransferAvg.addValue(byteCount);
        }
        if (this.longTransferAvg != null) {
            this.longTransferAvg.addValue(byteCount);
        }
        if (this.nextContollerInChain != null) {
            this.nextContollerInChain.markBytesUsed(byteCount);
        }
    }

    private void updateWindow(boolean blockTillAvailable) {
        boolean wasInterrupted = false;
        int updateTries = 0;
        while (true) {
            long now;
            long elapsedWindowMillis;
            if ((elapsedWindowMillis = (now = System.currentTimeMillis()) - this.lastWindowTime) >= 200L) {
                this.bytesRemaining = this.bytesRemaining < 0 ? (this.bytesRemaining += this.bytesPerWindow) : this.bytesPerWindow;
                this.lastWindowTime = now;
                if (NLogger.isDebugEnabled(BandwidthController.class)) {
                    NLogger.debug(BandwidthController.class, (Object)("[" + this.controllerName + "] Update new Window " + this.bytesPerWindow + " - Remaining: " + this.bytesRemaining + "."));
                }
            }
            if (!blockTillAvailable || this.bytesRemaining > 0 || ++updateTries > 10) break;
            try {
                Thread.sleep(Math.max(200L - elapsedWindowMillis, 0L));
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                break;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public String getName() {
        return this.controllerName;
    }

    public String toDebugString() {
        return "ThrottleController[Name:" + this.controllerName + ",bytesPerWindow:" + this.bytesPerWindow + ",bytesRemaining:" + this.bytesRemaining;
    }
}

