/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import phex.common.log.NLogger;

public class JThreadPool {
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public void executeNamed(Runnable runnable, String name) {
        this.pool.execute(new NamedThreadRunnable(name, runnable));
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    private static final class NamedThreadRunnable
    implements Runnable {
        private final String name;
        private final Runnable runnable;

        private NamedThreadRunnable(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            currentThread.setName(this.name + "-" + oldName);
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                NLogger.error(JThreadPool.class, (Object)t, t);
            }
            finally {
                currentThread.setName(oldName);
            }
        }
    }
}

