/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.net.repres.PresentationManager;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;

public class AlternateLocation {
    public static final Short DEFAULT_HOST_RATING = 6;
    private DestAddress hostAddress;
    private URN urn;

    public AlternateLocation(DestAddress hostAddress, URN urn) {
        this.hostAddress = hostAddress;
        this.urn = urn;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public URN getURN() {
        return this.urn;
    }

    public String getHTTPString() {
        return this.hostAddress.getFullHostName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlternateLocation)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AlternateLocation altLoc = (AlternateLocation)obj;
        return this.hostAddress.equals(altLoc.hostAddress) && this.urn.equals(altLoc.urn);
    }

    public int hashCode() {
        int h = 7;
        h = 31 * h + (this.hostAddress != null ? ((Object)this.hostAddress).hashCode() : 0);
        h = 31 * h + (this.urn != null ? this.urn.hashCode() : 0);
        return h;
    }

    public static AlternateLocation parseCompactIpAltLoc(String line, URN urn, PhexSecurityManager securityService) {
        DestAddress address;
        try {
            address = PresentationManager.getInstance().createHostAddress(line, -1);
        }
        catch (MalformedDestAddressException exp) {
            NLogger.debug(AlternateLocation.class, (Object)("Malformed alt-location URL: " + exp.getMessage()));
            return null;
        }
        AlternateLocation loc = new AlternateLocation(address, urn);
        return loc;
    }

    public static AlternateLocation parseUriResAltLoc(String line, PhexSecurityManager securityService) {
        StringTokenizer tokenizer = new StringTokenizer(line, " \t\n\r\f\"");
        String urlStr = null;
        if (tokenizer.hasMoreTokens()) {
            urlStr = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
        }
        try {
            DestAddress hostAddress;
            URL url = new URL(urlStr);
            String protocol = url.getProtocol();
            if (!"http".equals(protocol)) {
                NLogger.debug(AlternateLocation.class, (Object)("Invalid alt-location URL (Not a http URL): " + urlStr));
                return null;
            }
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                NLogger.error(AlternateLocation.class, (Object)"Invalid legacy alt-loc without specified port.");
                return null;
            }
            try {
                hostAddress = PresentationManager.getInstance().createHostAddress(host, port);
            }
            catch (MalformedDestAddressException e) {
                NLogger.debug(AlternateLocation.class, (Object)("Invalid alt-location URL (Invalid address): " + urlStr));
                return null;
            }
            if (!hostAddress.isValidAddress()) {
                NLogger.debug(AlternateLocation.class, (Object)("Invalid alt-location URL (Invalid address): " + urlStr));
                return null;
            }
            AccessType access = securityService.controlHostAddressAccess(hostAddress);
            switch (access) {
                case ACCESS_DENIED: 
                case ACCESS_STRONGLY_DENIED: {
                    NLogger.debug(AlternateLocation.class, (Object)("Alt-Location host denied: " + urlStr));
                    return null;
                }
            }
            if (!hostAddress.getIpAddress().isValidIP()) {
                NLogger.debug(AlternateLocation.class, (Object)("Invalid alt-location URL (Invalid IP used): " + urlStr));
                return null;
            }
            if (hostAddress.getIpAddress().isSiteLocalIP()) {
                NLogger.debug(AlternateLocation.class, (Object)("Invalid alt-location URL (Private IP used): " + urlStr));
                return null;
            }
            URN urn = URN.parseURNFromUriRes(url.getFile());
            if (urn == null) {
                NLogger.debug(AlternateLocation.class, (Object)("Alt-location path without URN: " + line));
                return null;
            }
            AlternateLocation loc = new AlternateLocation(hostAddress, urn);
            return loc;
        }
        catch (MalformedURLException exp) {
            NLogger.debug(AlternateLocation.class, (Object)("Invalid alt-location URL (Malformed: " + exp.getMessage() + " ): " + urlStr));
            return null;
        }
    }
}

