/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.SequencedHashMap;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.http.HTTPHeader;
import phex.security.PhexSecurityManager;
import phex.xml.sax.share.DAlternateLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltLocContainer {
    public static final int MAX_ALT_LOC_COUNT = 100;
    public static final int MAX_ALT_LOC_FOR_QUERY_COUNT = 10;
    private static final Object PRESENT = new Object();
    private URN urn;
    private SequencedHashMap altLocationMap;

    public AltLocContainer(URN urn) {
        if (urn == null) {
            throw new NullPointerException("URN must be provided");
        }
        this.urn = urn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainer(AltLocContainer cont) {
        if (cont.urn == null || !cont.urn.equals(this.urn)) {
            throw new IllegalArgumentException("Trying to add container with not matching urns");
        }
        if (cont.altLocationMap == null) {
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = cont.altLocationMap;
        synchronized (sequencedHashMap) {
            Set keySet = cont.altLocationMap.keySet();
            for (AlternateLocation tempAltLoc : keySet) {
                this.addAlternateLocation(tempAltLoc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlternateLocation(AlternateLocation altLoc) {
        URN altLocURN = altLoc.getURN();
        if (altLocURN == null || !altLocURN.equals(this.urn)) {
            NLogger.warn(AltLocContainer.class, (Object)"Cant add alt-location with not matching URN to container.");
            assert (false) : "Cant add alt-location with not matching URN to container.";
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            this.altLocationMap.put((Object)altLoc, PRESENT);
            if (this.altLocationMap.size() > 100) {
                Object firstKey = this.altLocationMap.getFirstKey();
                this.altLocationMap.remove(firstKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlternateLocation(AlternateLocation altLoc) {
        URN altLocURN = altLoc.getURN();
        if (altLocURN == null || !altLocURN.equals(this.urn)) {
            NLogger.warn(AltLocContainer.class, (Object)"Cant remove alt-location with not matching URN from container.");
            assert (false) : "Cant remove alt-location with not matching URN from container.";
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            this.altLocationMap.remove((Object)altLoc);
        }
    }

    public Set<DestAddress> getAltLocsForExport() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        Iterator iterator = this.altLocationMap.keySet().iterator();
        HashSet<DestAddress> result = new HashSet<DestAddress>();
        while (iterator.hasNext()) {
            AlternateLocation altLoc = (AlternateLocation)iterator.next();
            DestAddress destAddress = altLoc.getHostAddress();
            if (!destAddress.isIpHostName() || !destAddress.isLocalHost()) continue;
            result.add(destAddress);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DestAddress> getAltLocForQueryResponseRecord() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            HashSet<DestAddress> result = new HashSet<DestAddress>();
            while (iterator.hasNext() && result.size() < 10) {
                AlternateLocation altLoc = (AlternateLocation)iterator.next();
                DestAddress destAddress = altLoc.getHostAddress();
                if (!destAddress.isIpHostName() || !destAddress.isLocalHost()) continue;
                result.add(destAddress);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPHeader getAltLocHTTPHeaderForAddress(String headerName, DestAddress hostAddress, Set<AlternateLocation> sendAltLocSet) {
        if (this.isEmpty()) {
            return null;
        }
        int count = 0;
        StringBuffer headerValue = new StringBuffer();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            for (AlternateLocation altLoc : this.altLocationMap.keySet()) {
                if (hostAddress.getHostName().equals(altLoc.getHostAddress().getHostName()) || sendAltLocSet.contains(altLoc)) continue;
                if (count > 0) {
                    headerValue.append(",");
                }
                headerValue.append(altLoc.getHTTPString());
                sendAltLocSet.add(altLoc);
                if (++count != 10) continue;
                break;
            }
        }
        if (headerValue.length() > 0) {
            HTTPHeader altLocHeader = new HTTPHeader(headerName, headerValue.toString());
            return altLocHeader;
        }
        return null;
    }

    public synchronized int getSize() {
        if (this.altLocationMap == null) {
            return 0;
        }
        return this.altLocationMap.size();
    }

    public synchronized boolean isEmpty() {
        if (this.altLocationMap == null) {
            return true;
        }
        return this.altLocationMap.isEmpty();
    }

    public synchronized void createDAlternateLocationList(List<DAlternateLocation> list) {
        if (this.altLocationMap == null) {
            return;
        }
        for (AlternateLocation altLoc : this.altLocationMap.keySet()) {
            DAlternateLocation dAltLoc = new DAlternateLocation();
            dAltLoc.setHostAddress(altLoc.getHostAddress().getFullHostName());
            dAltLoc.setUrn(altLoc.getURN().getAsString());
            list.add(dAltLoc);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Alt-Locations(SHA1: ");
        stringBuffer.append(this.urn.getAsString());
        stringBuffer.append(")=[ ");
        if (this.altLocationMap != null) {
            for (AlternateLocation altLoc : this.altLocationMap.keySet()) {
                stringBuffer.append(altLoc.toString());
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    private void initMap() {
        if (this.altLocationMap == null) {
            this.altLocationMap = new SequencedHashMap();
        }
    }

    public static List<AlternateLocation> parseUriResAltLocFromHeaders(HTTPHeader[] headers, PhexSecurityManager securityService) {
        if (headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AlternateLocation> altLocList = new ArrayList<AlternateLocation>();
        for (int i = 0; i < headers.length; ++i) {
            HTTPHeader header = headers[i];
            StringTokenizer tokenizer = new StringTokenizer(header.getValue(), ",");
            while (tokenizer.hasMoreTokens()) {
                try {
                    String altLocationStr = tokenizer.nextToken().trim();
                    AlternateLocation altLocation = AlternateLocation.parseUriResAltLoc(altLocationStr, securityService);
                    if (altLocation == null) continue;
                    altLocList.add(altLocation);
                }
                catch (Exception exp) {
                    NLogger.error(AltLocContainer.class, (Object)exp, (Throwable)exp);
                }
            }
        }
        return altLocList;
    }

    public static List<AlternateLocation> parseCompactIpAltLocFromHeaders(HTTPHeader[] headers, URN urn, PhexSecurityManager securityService) {
        if (headers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AlternateLocation> altLocList = new ArrayList<AlternateLocation>();
        for (int i = 0; i < headers.length; ++i) {
            HTTPHeader header = headers[i];
            StringTokenizer tokenizer = new StringTokenizer(header.getValue(), ",");
            while (tokenizer.hasMoreTokens()) {
                try {
                    String altLocationStr = tokenizer.nextToken().trim();
                    AlternateLocation altLocation = AlternateLocation.parseCompactIpAltLoc(altLocationStr, urn, securityService);
                    if (altLocation == null) continue;
                    altLocList.add(altLocation);
                }
                catch (Exception exp) {
                    NLogger.error(AltLocContainer.class, (Object)exp, (Throwable)exp);
                }
            }
        }
        return altLocList;
    }
}

