/*
 * Decompiled with CFR 0.152.
 */
package phex.chat;

import java.io.IOException;
import phex.chat.ChatEvent;
import phex.chat.ChatService;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.io.buffer.ByteBuffer;
import phex.net.connection.Connection;
import phex.net.connection.ConnectionFactory;
import phex.prefs.core.NetworkPrefs;
import phex.servent.Servent;
import phex.utils.GnutellaInputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class ChatEngine {
    private final ChatService chatService;
    private final boolean isOutgoingConnection;
    private GnutellaInputStream chatReader;
    private Connection connection;
    private String chatNick;
    private boolean useEncodedStr = true;
    private final DestAddress hostAddress;

    protected ChatEngine(ChatService chatService, Connection connection) throws IOException {
        this.chatService = chatService;
        this.connection = connection;
        this.hostAddress = connection.getSocket().getRemoteAddress();
        this.chatReader = connection.getInputStream();
        this.chatNick = this.hostAddress.getFullHostName();
        this.finalizeHandshake();
        this.isOutgoingConnection = false;
    }

    protected ChatEngine(ChatService chatMgr, DestAddress aHostAddress) {
        this.chatService = chatMgr;
        this.hostAddress = aHostAddress;
        this.isOutgoingConnection = true;
        this.chatNick = this.hostAddress.getFullHostName();
    }

    public void startChat() {
        ChatReadWorker worker = new ChatReadWorker();
        Environment.getInstance().executeOnThreadPool(worker, "ChatReadWorker-" + Integer.toHexString(worker.hashCode()));
    }

    public void stopChat() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        this.chatService.chatClosed(this);
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getChatNick() {
        return this.chatNick;
    }

    public void sendChatMessage(String message) {
        if (this.connection == null) {
            this.chatService.fireChatConnectionFailed(this);
        }
        try {
            if (this.useEncodedStr) {
                String base64Str = new BASE64Encoder().encode(message.getBytes());
                this.connection.write(ByteBuffer.wrap((base64Str + "\n").getBytes()));
            } else {
                this.connection.write(ByteBuffer.wrap((message + "\n").getBytes()));
            }
        }
        catch (IOException exp) {
            NLogger.warn(ChatEngine.class, (Object)exp, (Throwable)exp);
            this.stopChat();
        }
    }

    private void finalizeHandshake() throws IOException {
        String line;
        this.connection.getSocket().setSoTimeout(NetworkPrefs.TcpRWTimeout.get());
        boolean foundPhexEncoded = false;
        do {
            line = this.chatReader.readLine();
            NLogger.debug(ChatEngine.class, (Object)("Read Chat header: " + line));
            if (line == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String upLine = line.toUpperCase();
            if (upLine.startsWith("X-NICKNAME:")) {
                this.chatNick = line.substring(11).trim();
                NLogger.debug(ChatEngine.class, (Object)("Chat Nick: " + this.chatNick));
            }
            if (!upLine.startsWith("X-PHEX-ENCODED:")) continue;
            foundPhexEncoded = true;
            this.useEncodedStr = upLine.equals("X-PHEX-ENCODED: TRUE");
        } while (line.length() > 0);
        if (!foundPhexEncoded) {
            this.useEncodedStr = false;
        }
        NLogger.debug(ChatEngine.class, (Object)"Sending: CHAT/0.1 200 OK");
        if (foundPhexEncoded) {
            this.connection.write(ByteBuffer.wrap(("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "X-Phex-Encoded: true" + "\r\n" + "\r\n").getBytes()));
        } else {
            this.connection.write(ByteBuffer.wrap(("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "\r\n").getBytes()));
        }
        do {
            line = this.chatReader.readLine();
            NLogger.debug(ChatEngine.class, (Object)("Read Chat response: " + line));
            if (line != null) continue;
            throw new IOException("No handshake response from chat partner.");
        } while (line.length() > 0);
        this.connection.getSocket().setSoTimeout(0);
    }

    private void connectOutgoingChat() throws IOException {
        String line;
        boolean foundPhexEncoded = false;
        NLogger.debug(ChatEngine.class, (Object)("Connect outgoing to: " + this.hostAddress));
        this.connection = ConnectionFactory.createConnection(this.hostAddress, this.chatService.getChatBandwidthController());
        String message = "CHAT CONNECT/0.1\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "X-Phex-Encoded: true" + "\r\n" + "\r\n";
        NLogger.debug(ChatEngine.class, (Object)("Sending: " + message));
        this.connection.write(ByteBuffer.wrap(message.getBytes()));
        this.chatReader = this.connection.getInputStream();
        do {
            line = this.chatReader.readLine();
            NLogger.debug(ChatEngine.class, (Object)("Read Chat header: " + line));
            if (line == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String upLine = line.toUpperCase();
            if (upLine.startsWith("X-NICKNAME:")) {
                this.chatNick = line.substring(11).trim();
            }
            if (!upLine.startsWith("X-PHEX-ENCODED:")) continue;
            foundPhexEncoded = true;
            this.useEncodedStr = upLine.equals("X-PHEX-ENCODED: TRUE");
        } while (line.length() > 0);
        if (!foundPhexEncoded) {
            this.useEncodedStr = false;
        }
        this.connection.write(ByteBuffer.wrap(("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n\r\n").getBytes()));
        this.connection.getSocket().setSoTimeout(0);
    }

    private class ChatReadWorker
    implements Runnable {
        private ChatReadWorker() {
        }

        public void run() {
            if (ChatEngine.this.isOutgoingConnection) {
                try {
                    ChatEngine.this.connectOutgoingChat();
                }
                catch (IOException exp) {
                    ChatEngine.this.stopChat();
                    return;
                }
            }
            try {
                while (true) {
                    String str;
                    if ((str = ChatEngine.this.chatReader.readLine()) == null) {
                        throw new IOException("Remote host diconnected chat.");
                    }
                    if (str.length() == 0) continue;
                    NLogger.debug(ChatEngine.class, (Object)("Reading chat message: " + str));
                    if (ChatEngine.this.useEncodedStr) {
                        byte[] base64Buf = new BASE64Decoder().decodeBuffer(str);
                        str = new String(base64Buf);
                    }
                    Servent.getInstance().getEventService().publish("phex:chat/update", new ChatEvent(ChatEvent.Type.MSG_REC, ChatEngine.this, str));
                }
            }
            catch (IOException exp) {
                NLogger.debug(ChatEngine.class, (Object)exp, (Throwable)exp);
                ChatEngine.this.stopChat();
                return;
            }
        }
    }
}

