/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.MessageInputStream;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;

public class MessageInputStreamTest {
    private I2PAppContext _context = I2PAppContext.getGlobalContext();
    private Log _log = this._context.logManager().getLog(class$net$i2p$client$streaming$MessageInputStreamTest == null ? (class$net$i2p$client$streaming$MessageInputStreamTest = MessageInputStreamTest.class$("net.i2p.client.streaming.MessageInputStreamTest")) : class$net$i2p$client$streaming$MessageInputStreamTest);
    static /* synthetic */ Class class$net$i2p$client$streaming$MessageInputStreamTest;

    public void testInOrder() {
        byte[] orig = new byte[262144];
        this._context.random().nextBytes(orig);
        MessageInputStream in = new MessageInputStream(this._context);
        for (int i = 0; i < orig.length / 1024; ++i) {
            byte[] msg = new byte[1024];
            System.arraycopy(orig, i * 1024, msg, 0, 1024);
            in.messageReceived(i, new ByteArray(msg));
        }
        byte[] read = new byte[orig.length];
        try {
            int howMany = DataHelper.read((InputStream)in, (byte[])read);
            if (howMany != orig.length) {
                throw new RuntimeException("Failed test: not enough bytes read [" + howMany + "]");
            }
            if (!DataHelper.eq((byte[])orig, (byte[])read)) {
                throw new RuntimeException("Failed test: data read is not equal");
            }
            this._log.info("Passed test: in order");
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOError reading: " + ioe.getMessage());
        }
    }

    public void testRandomOrder() {
        int i;
        byte[] orig = new byte[262144];
        this._context.random().nextBytes(orig);
        MessageInputStream in = new MessageInputStream(this._context);
        ArrayList<Integer> order = new ArrayList<Integer>(32);
        for (i = 0; i < orig.length / 1024; ++i) {
            order.add(new Integer(i));
        }
        Collections.shuffle(order);
        for (i = 0; i < orig.length / 1024; ++i) {
            byte[] msg = new byte[1024];
            Integer cur = (Integer)order.get(i);
            System.arraycopy(orig, cur * 1024, msg, 0, 1024);
            in.messageReceived(cur.intValue(), new ByteArray(msg));
            this._log.debug("Injecting " + cur);
        }
        byte[] read = new byte[orig.length];
        try {
            int howMany = DataHelper.read((InputStream)in, (byte[])read);
            if (howMany != orig.length) {
                throw new RuntimeException("Failed test: not enough bytes read [" + howMany + "]");
            }
            if (!DataHelper.eq((byte[])orig, (byte[])read)) {
                throw new RuntimeException("Failed test: data read is not equal");
            }
            this._log.info("Passed test: random order");
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOError reading: " + ioe.getMessage());
        }
    }

    public void testRandomDups() {
        byte[] orig = new byte[262144];
        this._context.random().nextBytes(orig);
        MessageInputStream in = new MessageInputStream(this._context);
        for (int n = 0; n < 3; ++n) {
            int i;
            ArrayList<Integer> order = new ArrayList<Integer>(32);
            for (i = 0; i < orig.length / 1024; ++i) {
                order.add(new Integer(i));
            }
            Collections.shuffle(order);
            for (i = 0; i < orig.length / 1024; ++i) {
                byte[] msg = new byte[1024];
                Integer cur = (Integer)order.get(i);
                System.arraycopy(orig, cur * 1024, msg, 0, 1024);
                in.messageReceived(cur.intValue(), new ByteArray(msg));
                this._log.debug("Injecting " + cur);
            }
        }
        byte[] read = new byte[orig.length];
        try {
            int howMany = DataHelper.read((InputStream)in, (byte[])read);
            if (howMany != orig.length) {
                throw new RuntimeException("Failed test: not enough bytes read [" + howMany + "]");
            }
            if (!DataHelper.eq((byte[])orig, (byte[])read)) {
                throw new RuntimeException("Failed test: data read is not equal");
            }
            this._log.info("Passed test: random dups");
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOError reading: " + ioe.getMessage());
        }
    }

    public void testStaggered() {
        byte[] orig = new byte[262144];
        byte[] read = new byte[orig.length];
        this._context.random().nextBytes(orig);
        MessageInputStream in = new MessageInputStream(this._context);
        ArrayList<Integer> order = new ArrayList<Integer>(32);
        for (int i = 0; i < orig.length / 1024; ++i) {
            order.add(new Integer(i));
        }
        Collections.shuffle(order);
        int offset = 0;
        for (int i = 0; i < orig.length / 1024; ++i) {
            byte[] msg = new byte[1024];
            Integer cur = (Integer)order.get(i);
            System.arraycopy(orig, cur * 1024, msg, 0, 1024);
            in.messageReceived(cur.intValue(), new ByteArray(msg));
            this._log.debug("Injecting " + cur);
            try {
                if (in.available() <= 0) continue;
                int curRead = in.read(read, offset, read.length - offset);
                this._log.debug("read " + curRead);
                if (curRead == -1) {
                    throw new RuntimeException("EOF with offset " + offset);
                }
                offset += curRead;
                continue;
            }
            catch (IOException ioe) {
                throw new RuntimeException("IOE: " + ioe.getMessage());
            }
        }
        if (!DataHelper.eq((byte[])orig, (byte[])read)) {
            throw new RuntimeException("Failed test: data read is not equal");
        }
        this._log.info("Passed test: staggered");
    }

    public static void main(String[] args) {
        MessageInputStreamTest t = new MessageInputStreamTest();
        try {
            t.testInOrder();
            t.testRandomOrder();
            t.testRandomDups();
            t.testStaggered();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

