/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionManager;
import net.i2p.client.streaming.Packet;
import net.i2p.client.streaming.PacketLocal;
import net.i2p.client.streaming.RetransmissionTimer;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class ConnectionHandler {
    private I2PAppContext _context;
    private Log _log;
    private ConnectionManager _manager;
    private List _synQueue;
    private boolean _active;
    private int _acceptTimeout;
    private static final int DEFAULT_ACCEPT_TIMEOUT = 3000;
    static /* synthetic */ Class class$net$i2p$client$streaming$ConnectionHandler;

    public ConnectionHandler(I2PAppContext context, ConnectionManager mgr) {
        this._context = context;
        this._log = context.logManager().getLog(class$net$i2p$client$streaming$ConnectionHandler == null ? (class$net$i2p$client$streaming$ConnectionHandler = ConnectionHandler.class$("net.i2p.client.streaming.ConnectionHandler")) : class$net$i2p$client$streaming$ConnectionHandler);
        this._manager = mgr;
        this._synQueue = new ArrayList(5);
        this._active = false;
        this._acceptTimeout = 3000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active) {
        if (this._log.shouldLog(10)) {
            this._log.debug("setActive(" + active + ") called");
        }
        List list = this._synQueue;
        synchronized (list) {
            this._active = active;
            this._synQueue.notifyAll();
        }
    }

    public boolean getActive() {
        return this._active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveNewSyn(Packet packet) {
        if (!this._active) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping new SYN request, as we're not listening");
            }
            this.sendReset(packet);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive new SYN: " + packet + ": timeout in " + this._acceptTimeout);
        }
        RetransmissionTimer.getInstance().addEvent((SimpleTimer.TimedEvent)new TimeoutSyn(packet), (long)this._acceptTimeout);
        List list = this._synQueue;
        synchronized (list) {
            this._synQueue.add(packet);
            this._synQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection accept(long timeoutMs) {
        Connection con;
        Packet syn;
        if (this._log.shouldLog(10)) {
            this._log.debug("Accept(" + timeoutMs + ") called");
        }
        long expiration = timeoutMs + this._context.clock().now();
        do {
            if (timeoutMs > 0L && expiration < this._context.clock().now()) {
                return null;
            }
            if (!this._active) {
                List list = this._synQueue;
                synchronized (list) {
                    int i = 0;
                    while (true) {
                        if (i >= this._synQueue.size()) {
                            this._synQueue.clear();
                            return null;
                        }
                        Packet packet = (Packet)this._synQueue.get(i);
                        this.sendReset(packet);
                        ++i;
                    }
                }
            }
            syn = null;
            List i = this._synQueue;
            synchronized (i) {
                while (this._active && this._synQueue.size() <= 0) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Accept(" + timeoutMs + "): active=" + this._active + " queue: " + this._synQueue.size());
                    }
                    if (timeoutMs <= 0L) {
                        try {
                            this._synQueue.wait();
                        }
                        catch (InterruptedException ie) {}
                        continue;
                    }
                    long remaining = expiration - this._context.clock().now();
                    if (remaining < 0L) break;
                    try {
                        this._synQueue.wait(remaining);
                    }
                    catch (InterruptedException ie) {}
                }
                if (this._active && this._synQueue.size() > 0) {
                    syn = (Packet)this._synQueue.remove(0);
                }
            }
        } while (syn == null || (con = this._manager.receiveConnection(syn)) == null);
        return con;
    }

    private void sendReset(Packet packet) {
        boolean ok = packet.verifySignature(this._context, packet.getOptionalFrom(), null);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Received a spoofed SYN packet: they said they were " + packet.getOptionalFrom());
            }
            return;
        }
        PacketLocal reply = new PacketLocal(this._context, packet.getOptionalFrom());
        reply.setFlag(4);
        reply.setFlag(8);
        reply.setAckThrough(packet.getSequenceNum());
        reply.setSendStreamId(packet.getReceiveStreamId());
        reply.setReceiveStreamId(0L);
        reply.setOptionalFrom(this._manager.getSession().getMyDestination());
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending RST: " + reply + " because of " + packet);
        }
        this._manager.getPacketQueue().enqueue(reply);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TimeoutSyn
    implements SimpleTimer.TimedEvent {
        private Packet _synPacket;

        public TimeoutSyn(Packet packet) {
            this._synPacket = packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            boolean removed = false;
            List list = ConnectionHandler.this._synQueue;
            synchronized (list) {
                removed = ConnectionHandler.this._synQueue.remove(this._synPacket);
            }
            if (removed) {
                ConnectionHandler.this.sendReset(this._synPacket);
            }
        }
    }
}

