/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.thex;

import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.xml.thex.ThexHashTree;

public class ThexHashTreeSAXHandler
extends DefaultHandler {
    private static final String THEX_HASHTREE_DTD = "http://open-content.net/spec/thex/thex.dtd";
    private static final String FILE_ELEMENT = "file";
    private static final String DIGEST_ELEMENT = "digest";
    private static final String SERIALIZEDTREE_ELEMENT = "serializedtree";
    private ThexHashTree hashtree;

    public ThexHashTreeSAXHandler(ThexHashTree hashtree) {
        this.hashtree = hashtree;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (FILE_ELEMENT.equals(qName)) {
            this.hashtree.setFileSize(attributes.getValue("size"));
            this.hashtree.setFileSegmentSize(attributes.getValue("segmentsize"));
        } else if (DIGEST_ELEMENT.equals(qName)) {
            this.hashtree.setDigestAlgorithm(attributes.getValue("algorithm"));
            this.hashtree.setDigestOutputSize(attributes.getValue("outputsize"));
        } else if (SERIALIZEDTREE_ELEMENT.equals(qName)) {
            this.hashtree.setSerializedTreeDepth(attributes.getValue("depth"));
            this.hashtree.setSerializedTreeType(attributes.getValue("type"));
            this.hashtree.setSerializedTreeUri(attributes.getValue("uri"));
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.equals(THEX_HASHTREE_DTD)) {
            InputStream stream = ThexHashTreeSAXHandler.class.getResourceAsStream("/phex/xml/thex/ThexHashTree.dtd");
            return new InputSource(stream);
        }
        return null;
    }
}

