/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import phex.common.MediaType;
import phex.rules.condition.Condition;
import phex.rules.condition.MediaTypeCondition;
import phex.xml.sax.PhexXmlSaxWriter;
import phex.xml.sax.rules.DCondition;

public class DMediaTypeCondition
implements DCondition {
    public static final String ELEMENT_NAME = "mediatype-condition";
    private List<MediaType> types = new ArrayList<MediaType>();

    public List<MediaType> getTypes() {
        return this.types;
    }

    public void setTypes(List<MediaType> types) {
        this.types = types;
    }

    @Override
    public void serialize(PhexXmlSaxWriter writer) throws SAXException {
        writer.startElm(ELEMENT_NAME, null);
        if (this.types != null) {
            AttributesImpl attributes = null;
            for (MediaType type : this.types) {
                attributes = new AttributesImpl();
                attributes.addAttribute("", "", "name", "CDATA", String.valueOf(type.getName()));
                writer.startElm("media", attributes);
                writer.endElm("media");
            }
        }
        writer.endElm(ELEMENT_NAME);
    }

    @Override
    public Condition createCondition() {
        MediaTypeCondition cond = new MediaTypeCondition();
        Iterator<MediaType> iterator = this.types.iterator();
        while (iterator.hasNext()) {
            cond.addType(iterator.next());
        }
        return cond;
    }
}

