/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;
import phex.common.URN;
import phex.rules.condition.Condition;
import phex.rules.condition.FileUrnCondition;
import phex.xml.sax.PhexXmlSaxWriter;
import phex.xml.sax.rules.DCondition;

public class DFileUrnCondition
implements DCondition {
    public static final String ELEMENT_NAME = "fileurn-condition";
    private List<String> urns = new ArrayList<String>();

    public List<String> getUrns() {
        return this.urns;
    }

    public void setUrns(List<String> urns) {
        this.urns = urns;
    }

    @Override
    public void serialize(PhexXmlSaxWriter writer) throws SAXException {
        writer.startElm(ELEMENT_NAME, null);
        if (this.urns != null) {
            Iterator<String> iterator = this.urns.iterator();
            while (iterator.hasNext()) {
                writer.startElm("urn", null);
                writer.elmText(iterator.next());
                writer.endElm("urn");
            }
        }
        writer.endElm(ELEMENT_NAME);
    }

    @Override
    public Condition createCondition() {
        FileUrnCondition cond = new FileUrnCondition();
        for (String urn : this.urns) {
            if (!URN.isValidURN(urn)) continue;
            cond.addUrn(new URN(urn));
        }
        return cond;
    }
}

