/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import phex.rules.condition.Condition;
import phex.rules.condition.FileSizeCondition;
import phex.xml.sax.PhexXmlSaxWriter;
import phex.xml.sax.rules.DCondition;

public class DFileSizeCondition
implements DCondition {
    public static final String ELEMENT_NAME = "filesize-condition";
    private List<FileSizeCondition.Range> ranges = new ArrayList<FileSizeCondition.Range>();

    public List<FileSizeCondition.Range> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<FileSizeCondition.Range> ranges) {
        this.ranges = ranges;
    }

    @Override
    public void serialize(PhexXmlSaxWriter writer) throws SAXException {
        writer.startElm(ELEMENT_NAME, null);
        if (this.ranges != null) {
            AttributesImpl attributes = null;
            for (FileSizeCondition.Range range : this.ranges) {
                attributes = new AttributesImpl();
                attributes.addAttribute("", "", "min", "CDATA", String.valueOf(range.min));
                attributes.addAttribute("", "", "max", "CDATA", String.valueOf(range.max));
                writer.startElm("range", attributes);
                writer.endElm("range");
            }
        }
        writer.endElm(ELEMENT_NAME);
    }

    @Override
    public Condition createCondition() {
        FileSizeCondition cond = new FileSizeCondition();
        Iterator<FileSizeCondition.Range> iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            cond.addRange(iterator.next());
        }
        return cond;
    }
}

