/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.gui;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.xml.sax.gui.DTable;
import phex.xml.sax.gui.DTableList;
import phex.xml.sax.parser.gui.GuiTableHandler;

public class GuiTableListHandler
extends DefaultHandler {
    public static final String THIS_TAG_NAME = "table-list";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DTableList dList;
    private DefaultHandler parent;

    public GuiTableListHandler(DTableList dList, Attributes attributes, DefaultHandler parent, SAXParser parser) {
        String vLines;
        this.dList = dList;
        this.parser = parser;
        this.parent = parent;
        String hLines = attributes.getValue("showHorizontalLines");
        if (hLines != null) {
            dList.setShowHorizontalLines(Boolean.valueOf(hLines));
        }
        if ((vLines = attributes.getValue("showVerticalLines")) != null) {
            dList.setShowVerticalLines(Boolean.valueOf(vLines));
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
        if (qName.equals("table")) {
            DTable table = new DTable();
            this.dList.getTableList().add(table);
            GuiTableHandler handler = new GuiTableHandler(table, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(THIS_TAG_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

