/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.downloads;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.common.log.NLogger;
import phex.xml.sax.downloads.DDownloadSegment;

public class DownloadSegmentHandler
extends DefaultHandler {
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DDownloadSegment downloadSegment;
    private DefaultHandler parent;

    public DownloadSegmentHandler(DDownloadSegment downloadSegment, DefaultHandler parent, SAXParser parser) {
        this.downloadSegment = downloadSegment;
        this.parser = parser;
        this.parent = parent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("incompleteFileName")) {
            this.downloadSegment.setIncompleteFileName(this.text.toString());
        } else if (qName.equals("segmentNumber")) {
            try {
                this.downloadSegment.setSegmentNumber(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadSegmentHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("startPosition")) {
            try {
                this.downloadSegment.setStartPos(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadSegmentHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("length")) {
            try {
                this.downloadSegment.setLength(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadSegmentHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("transferred")) {
            try {
                this.downloadSegment.setTransferred(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadSegmentHandler.class, (Object)exp, (Throwable)exp);
            }
        } else if (qName.equals("segment")) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

