/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.DUpdateResponse;
import phex.xml.sax.downloads.DDownloadFile;
import phex.xml.sax.favorites.DFavoriteHost;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.parser.UpdateResponseHandler;
import phex.xml.sax.parser.downloads.DownloadListHandler;
import phex.xml.sax.parser.favorites.FavoritesListHandler;
import phex.xml.sax.parser.gui.GuiSettingsHandler;
import phex.xml.sax.parser.rules.SearchRuleListHandler;
import phex.xml.sax.parser.security.SecurityHandler;
import phex.xml.sax.parser.share.SharedLibraryHandler;
import phex.xml.sax.rules.DSearchRule;
import phex.xml.sax.security.DSecurity;
import phex.xml.sax.share.DSharedLibrary;

public class PhexSAXHandler
extends DefaultHandler {
    private static final String PHEX_ELEMENT = "phex";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DPhex dPhex;

    public PhexSAXHandler(DPhex dPhex, SAXParser parser) {
        this.dPhex = dPhex;
        this.parser = parser;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
        if (PHEX_ELEMENT.equals(qName)) {
            String phexVersion = attributes.getValue("phex-version");
            this.dPhex.setPhexVersion(phexVersion);
        } else if (qName.equals("update-response")) {
            DUpdateResponse dResponse = new DUpdateResponse();
            this.dPhex.setUpdateResponse(dResponse);
            UpdateResponseHandler handler = new UpdateResponseHandler(dResponse, attributes, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("update-request")) {
            assert (false) : "We should not pare update-request";
        } else if (qName.equals("sharedLibrary")) {
            DSharedLibrary sharedLib = new DSharedLibrary();
            this.dPhex.setSharedLibrary(sharedLib);
            SharedLibraryHandler handler = new SharedLibraryHandler(sharedLib, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("gui-settings")) {
            DGuiSettings dGui = new DGuiSettings();
            this.dPhex.setGuiSettings(dGui);
            GuiSettingsHandler handler = new GuiSettingsHandler(dGui, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("favorites-list")) {
            DSubElementList<DFavoriteHost> favoritsList = new DSubElementList<DFavoriteHost>("favorites-list");
            this.dPhex.setFavoritesList(favoritsList);
            FavoritesListHandler handler = new FavoritesListHandler(favoritsList, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("search-rule-list")) {
            DSubElementList<DSearchRule> ruleList = new DSubElementList<DSearchRule>("search-rule-list");
            this.dPhex.setSearchRuleList(ruleList);
            SearchRuleListHandler handler = new SearchRuleListHandler(ruleList, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("swDownloadList")) {
            DSubElementList<DDownloadFile> downloadList = new DSubElementList<DDownloadFile>("swDownloadList");
            this.dPhex.setDownloadList(downloadList);
            DownloadListHandler handler = new DownloadListHandler(downloadList, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("security")) {
            DSecurity security = new DSecurity();
            this.dPhex.setSecurityList(security);
            SecurityHandler handler = new SecurityHandler(security, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

