/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.OutputStream;
import phex.utils.FixedDeflaterOutputStream;

public class GnutellaOutputStream
extends OutputStream {
    private boolean isOutputDeflated;
    private OutputStream outStream;

    public GnutellaOutputStream(OutputStream outStream) {
        this.outStream = outStream;
        this.isOutputDeflated = false;
    }

    public void activateOutputDeflation() {
        FixedDeflaterOutputStream deflaterOutStream = new FixedDeflaterOutputStream(this.outStream);
        this.outStream = deflaterOutStream;
        this.isOutputDeflated = true;
    }

    @Override
    public void write(int b) throws IOException {
        int totalOut = 0;
        if (this.isOutputDeflated) {
            totalOut = ((FixedDeflaterOutputStream)this.outStream).getTotalOut();
        }
        this.outStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int totalOut = 0;
        if (this.isOutputDeflated) {
            totalOut = ((FixedDeflaterOutputStream)this.outStream).getTotalOut();
        }
        this.outStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.outStream.flush();
    }
}

