/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CircularQueue {
    private int size;
    private Object[] elements;
    private int headIdx;
    private int tailIdx;

    public CircularQueue(int maxSize) {
        this(Math.min(10, maxSize), maxSize);
    }

    public CircularQueue(int initialSize, int maxSize) {
        if (maxSize < 1) {
            throw new RuntimeException("Min size of the CircularQueue is 1");
        }
        this.size = maxSize + 1;
        this.elements = new Object[initialSize + 1];
        this.tailIdx = 0;
        this.headIdx = 0;
    }

    public Object addToTail(Object obj) {
        Object dropObj = null;
        if (this.isFull()) {
            dropObj = this.removeFromHead();
        }
        this.ensureCapacity();
        this.elements[this.tailIdx] = obj;
        this.tailIdx = this.nextIndex(this.tailIdx);
        return dropObj;
    }

    public Object addToHead(Object obj) {
        Object dropObj = null;
        if (this.isFull()) {
            dropObj = this.removeFromTail();
        }
        this.ensureCapacity();
        this.headIdx = this.prevIndex(this.headIdx);
        this.elements[this.headIdx] = obj;
        return dropObj;
    }

    public void clear() {
        this.headIdx = 0;
        this.tailIdx = 0;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[this.headIdx];
    }

    public Object getLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int index = this.prevIndex(this.tailIdx);
        return this.elements[index];
    }

    public Object get(int index) throws IndexOutOfBoundsException {
        int idx = this.mapIndex(index);
        return this.elements[idx];
    }

    public int getSize() {
        if (this.headIdx <= this.tailIdx) {
            return this.tailIdx - this.headIdx;
        }
        return this.elements.length - this.headIdx + this.tailIdx;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    public boolean isEmpty() {
        return this.headIdx == this.tailIdx;
    }

    public boolean isFull() {
        if (this.elements.length == this.size) {
            return this.nextIndex(this.tailIdx) == this.headIdx;
        }
        return false;
    }

    public Object removeFromHead() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object obj = this.elements[this.headIdx];
        this.elements[this.headIdx] = null;
        this.headIdx = this.nextIndex(this.headIdx);
        return obj;
    }

    public Object removeFromTail() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tailIdx = this.prevIndex(this.tailIdx);
        Object obj = this.elements[this.tailIdx];
        this.elements[this.tailIdx] = null;
        return obj;
    }

    public Object remove(int idx) throws IndexOutOfBoundsException {
        Object obj = this.get(idx);
        int i = this.mapIndex(idx);
        while (i != this.tailIdx) {
            this.elements[i] = this.elements[this.nextIndex(i)];
            i = this.nextIndex(i);
        }
        this.tailIdx = this.prevIndex(this.tailIdx);
        this.elements[this.tailIdx] = null;
        return obj;
    }

    public boolean removeAll(Object obj) {
        boolean removed = false;
        for (int i = 0; i < this.getSize(); ++i) {
            if (!obj.equals(this.get(i))) continue;
            this.remove(i);
            --i;
            removed = true;
        }
        return removed;
    }

    public Iterator iterator() {
        return new CircularQueueIterator();
    }

    private void ensureCapacity() {
        if (this.elements.length == this.size) {
            return;
        }
        if (this.nextIndex(this.tailIdx) != this.headIdx) {
            return;
        }
        int newSize = Math.min(this.elements.length * 2, this.size);
        Object[] newElements = new Object[newSize];
        if (this.headIdx <= this.tailIdx) {
            System.arraycopy(this.elements, this.headIdx, newElements, this.headIdx, this.tailIdx - this.headIdx);
        } else {
            int newHeadIdx = newSize - (this.elements.length - this.headIdx);
            if (this.tailIdx > 0) {
                System.arraycopy(this.elements, 0, newElements, 0, this.tailIdx - 1);
            }
            System.arraycopy(this.elements, this.headIdx, newElements, newHeadIdx, this.elements.length - this.headIdx);
            this.headIdx = newHeadIdx;
        }
        this.elements = newElements;
    }

    private int mapIndex(int index) throws IndexOutOfBoundsException {
        if (index >= this.elements.length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.elements.length);
        }
        return (index + this.headIdx) % this.elements.length;
    }

    private int nextIndex(int idx) {
        if (idx == this.elements.length - 1) {
            return 0;
        }
        return idx + 1;
    }

    private int prevIndex(int idx) {
        if (idx == 0) {
            return this.elements.length - 1;
        }
        return idx - 1;
    }

    private class CircularQueueIterator
    implements Iterator {
        int originalHead;
        int originalTail;
        int nextElement;

        public CircularQueueIterator() {
            this.nextElement = CircularQueue.this.headIdx;
            this.originalHead = CircularQueue.this.headIdx;
            this.originalTail = CircularQueue.this.tailIdx;
        }

        @Override
        public boolean hasNext() {
            this.checkForComodification();
            return this.nextElement != CircularQueue.this.tailIdx;
        }

        public Object next() throws NoSuchElementException {
            this.checkForComodification();
            if (this.nextElement == CircularQueue.this.tailIdx) {
                throw new NoSuchElementException();
            }
            Object obj = CircularQueue.this.elements[this.nextElement];
            this.nextElement = CircularQueue.this.nextIndex(this.nextElement);
            return obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void checkForComodification() {
            if (this.originalHead != CircularQueue.this.headIdx || this.originalTail != CircularQueue.this.tailIdx) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

