/*
 * Decompiled with CFR 0.152.
 */
package phex.upload.response;

import java.io.IOException;
import phex.common.file.FileManager;
import phex.common.file.ManagedFileException;
import phex.common.file.ReadOnlyManagedFile;
import phex.common.log.NLogger;
import phex.http.HTTPResponse;
import phex.io.buffer.ByteBuffer;
import phex.share.ShareFile;
import phex.upload.response.UploadResponse;
import phex.utils.IOUtil;

public class ShareFileUploadResponse
extends UploadResponse {
    private ShareFile shareFile;
    private ReadOnlyManagedFile uploadFile;
    private long startOffset;
    private long currentOffset;
    private long length;

    public ShareFileUploadResponse(ShareFile shareFile, long offset, long length) throws ManagedFileException {
        this.shareFile = shareFile;
        this.uploadFile = FileManager.getInstance().getReadOnlyManagedFile(shareFile.getSystemFile());
        this.currentOffset = this.startOffset = offset;
        this.length = length;
        this.httpResponse = offset == 0L && length == this.uploadFile.getLength() ? new HTTPResponse(200, "OK", true) : new HTTPResponse(206, "Partial Content", true);
    }

    @Override
    public int remainingBody() {
        return (int)(this.startOffset + this.length - this.currentOffset);
    }

    @Override
    public int fillBody(ByteBuffer byteBuffer) throws IOException {
        try {
            if (NLogger.isDebugEnabled(ShareFileUploadResponse.class)) {
                String log = "Reading in " + byteBuffer.remaining() + " bytes at " + this.currentOffset + " from " + this.uploadFile;
                NLogger.debug(ShareFileUploadResponse.class, (Object)log);
            }
            int read = this.uploadFile.read(byteBuffer, this.currentOffset);
            this.currentOffset += (long)read;
            return read;
        }
        catch (ManagedFileException exp) {
            IOException ioExp = new IOException("ManagedFileException: " + exp.getMessage());
            ioExp.initCause(exp);
            throw ioExp;
        }
    }

    @Override
    public void countUpload() {
        this.shareFile.incUploadCount();
    }

    @Override
    public void close() {
        IOUtil.closeQuietly(this.uploadFile);
    }
}

