/*
 * Decompiled with CFR 0.152.
 */
package phex.upload.handler;

import java.io.IOException;
import phex.common.URN;
import phex.http.HTTPHeader;
import phex.http.HTTPRequest;
import phex.share.ShareFile;
import phex.share.SharedFilesService;
import phex.upload.UploadState;
import phex.upload.handler.AbstractUploadHandler;
import phex.upload.response.ThexUploadResponse;
import phex.upload.response.UploadResponse;

public class ThexUploadHandler
extends AbstractUploadHandler {
    public ThexUploadHandler(SharedFilesService sharedFilesService) {
        super(sharedFilesService);
    }

    @Override
    protected UploadResponse determineFailFastResponse(HTTPRequest httpRequest, UploadState uploadState, ShareFile requestedFile) {
        return null;
    }

    @Override
    public UploadResponse finalizeUploadResponse(HTTPRequest httpRequest, UploadState uploadState, ShareFile requestedFile) throws IOException {
        uploadState.setFileName(requestedFile.getFileName());
        ThexUploadResponse response = new ThexUploadResponse(requestedFile, this.sharedFilesService);
        response.addHttpHeader(new HTTPHeader("Content-Type", "application/dime"));
        response.addHttpHeader(new HTTPHeader("Content-Length", String.valueOf(response.remainingBody())));
        URN sharedFileURN = requestedFile.getURN();
        if (sharedFileURN != null) {
            response.addHttpHeader(new HTTPHeader("X-Gnutella-Content-URN", sharedFileURN.getAsString()));
        }
        return response;
    }
}

