/*
 * Decompiled with CFR 0.152.
 */
package phex.upload.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.log.NLogger;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.http.GnutellaRequest;
import phex.http.HTTPHeader;
import phex.http.HTTPRequest;
import phex.prefs.core.UploadPrefs;
import phex.share.PartialShareFile;
import phex.share.ShareFile;
import phex.share.SharedFilesService;
import phex.upload.UploadEngine;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.upload.UploadStatus;
import phex.upload.handler.UploadHandler;
import phex.upload.response.UploadResponse;

public abstract class AbstractUploadHandler
implements UploadHandler {
    private boolean isPersistentConnection;
    private boolean isUploadQueued;
    private long queueMinNextPollTime;
    private int queueMaxNextPollTime;
    protected final SharedFilesService sharedFilesService;

    public AbstractUploadHandler(SharedFilesService sharedFilesService) {
        this.sharedFilesService = sharedFilesService;
    }

    @Override
    public UploadResponse determineUploadResponse(HTTPRequest httpRequest, UploadState uploadState, UploadManager uploadMgr) throws IOException {
        HTTPHeader header;
        boolean succ;
        String logMsg = "HTTP Request: " + httpRequest.buildHTTPRequestString();
        NLogger.debug(AbstractUploadHandler.class, (Object)logMsg);
        uploadState.addToUploadLog(logMsg);
        if (uploadState.getStatus() == UploadStatus.ACCEPTING_REQUEST && !(succ = uploadMgr.validateAndCountAddress(uploadState.getHostAddress()))) {
            this.isPersistentConnection = false;
            return UploadResponse.get503UploadLimitReachedForIP();
        }
        GnutellaRequest gRequest = httpRequest.getGnutellaRequest();
        assert (gRequest != null) : "Not a Gnutella file request.";
        ShareFile requestedFile = AbstractUploadHandler.findShareFile(gRequest, uploadState, this.sharedFilesService);
        if (requestedFile == null) {
            this.isPersistentConnection = false;
            return UploadResponse.get404FileNotFound();
        }
        this.isUploadQueued = false;
        if (uploadState.getStatus() == UploadStatus.ACCEPTING_REQUEST && uploadMgr.isHostBusy()) {
            header = httpRequest.getHeader("X-Queue");
            if (header == null || !UploadPrefs.AllowQueuing.get().booleanValue() || uploadMgr.isQueueLimitReached()) {
                this.isPersistentConnection = false;
                return UploadResponse.get503UploadLimitReached(requestedFile, uploadState);
            }
            this.isUploadQueued = true;
        }
        uploadState.setStatus(UploadStatus.HANDSHAKE);
        int port = -1;
        header = httpRequest.getHeader("X-Node");
        if (header == null) {
            header = httpRequest.getHeader("X-Listen-IP");
        }
        if (header == null) {
            header = httpRequest.getHeader("Listen-IP");
        }
        if (header == null) {
            header = httpRequest.getHeader("X-My-Address");
        }
        if (header != null) {
            port = AddressUtils.parsePort(header.getValue());
        }
        if (port > 0) {
            uploadState.getHostAddress().setPort(port);
        }
        this.handleConnectionHeader(httpRequest);
        String vendor = null;
        header = httpRequest.getHeader("User-Agent");
        vendor = header != null ? header.getValue() : "";
        uploadState.setVendor(vendor);
        UploadResponse response = this.determineFailFastResponse(httpRequest, uploadState, requestedFile);
        if (response != null) {
            return response;
        }
        if (this.isUploadQueued) {
            int queuePosition = uploadMgr.getQueuedPosition(uploadState);
            if (queuePosition < 0) {
                queuePosition = uploadMgr.addQueuedUpload(uploadState);
            }
            uploadState.setStatus(UploadStatus.QUEUED);
            int queueLength = uploadMgr.getUploadQueueSize();
            int uploadLimit = UploadPrefs.MaxParallelUploads.get();
            int pollMin = UploadPrefs.MinQueuePollTime.get();
            int pollMax = UploadPrefs.MaxQueuePollTime.get();
            this.queueMinNextPollTime = System.currentTimeMillis() + (long)(pollMin * 1000);
            this.queueMaxNextPollTime = pollMax * 1000;
            return UploadResponse.get503Queued(queuePosition, queueLength, uploadLimit, pollMin, pollMax, requestedFile, uploadState);
        }
        if (!uploadMgr.containsUploadState(uploadState)) {
            uploadMgr.addUploadState(uploadState);
        }
        return this.finalizeUploadResponse(httpRequest, uploadState, requestedFile);
    }

    protected abstract UploadResponse determineFailFastResponse(HTTPRequest var1, UploadState var2, ShareFile var3);

    protected abstract UploadResponse finalizeUploadResponse(HTTPRequest var1, UploadState var2, ShareFile var3) throws IOException;

    protected void handleAltLocRequestHeader(HTTPRequest httpRequest, UploadState uploadState, ShareFile requestedShareFile, URN sharedFileURN) {
        ArrayList<AlternateLocation> allAltLocs = new ArrayList<AlternateLocation>();
        HTTPHeader[] headers = httpRequest.getHeaders("Alt-Location");
        List<AlternateLocation> altLocList = AltLocContainer.parseUriResAltLocFromHeaders(headers);
        allAltLocs.addAll(altLocList);
        headers = httpRequest.getHeaders("X-Gnutella-Alternate-Location");
        altLocList = AltLocContainer.parseUriResAltLocFromHeaders(headers);
        allAltLocs.addAll(altLocList);
        headers = httpRequest.getHeaders("X-Alt");
        altLocList = AltLocContainer.parseCompactIpAltLocFromHeaders(headers, sharedFileURN);
        allAltLocs.addAll(altLocList);
        if (allAltLocs.size() == 0) {
            return;
        }
        AltLocContainer altLocContainer = requestedShareFile.getAltLocContainer();
        for (AlternateLocation altLoc : allAltLocs) {
            String logMsg = "Adding AltLoc " + altLoc.getHTTPString();
            NLogger.debug(UploadEngine.class, (Object)logMsg);
            uploadState.addToUploadLog(logMsg);
            altLocContainer.addAlternateLocation(altLoc);
        }
    }

    public void handleConnectionHeader(HTTPRequest httpRequest) {
        HTTPHeader header = httpRequest.getHeader("Connection");
        this.isPersistentConnection = "HTTP/1.1".equals(httpRequest.getHTTPVersion()) ? header == null || !header.getValue().equalsIgnoreCase("CLOSE") : header != null && header.getValue().equalsIgnoreCase("KEEP-ALIVE");
    }

    @Override
    public boolean isPersistentConnection() {
        return this.isPersistentConnection;
    }

    @Override
    public boolean isQueued() {
        return this.isUploadQueued;
    }

    @Override
    public long getQueueMinNextPollTime() {
        return this.queueMinNextPollTime;
    }

    @Override
    public int getQueueMaxNextPollTime() {
        return this.queueMaxNextPollTime;
    }

    private static ShareFile findShareFile(GnutellaRequest gRequest, UploadState uploadState, SharedFilesService sharedFilesService) {
        ShareFile shareFile = null;
        URN requestURN = gRequest.getURN();
        if (requestURN != null) {
            SwarmingManager swMgr;
            SWDownloadFile dwFile;
            if (!requestURN.isSha1Nid()) {
                requestURN = new URN("urn:sha1:" + requestURN.getSHA1Nss());
            }
            if ((shareFile = sharedFilesService.getFileByURN(requestURN)) == null && UploadPrefs.SharePartialFiles.get().booleanValue() && (dwFile = (swMgr = SwarmingManager.getInstance()).getDownloadFileByURN(requestURN)) != null) {
                shareFile = new PartialShareFile(dwFile);
            }
        } else if (gRequest.getFileIndex() != -1) {
            int index = gRequest.getFileIndex();
            shareFile = sharedFilesService.getFileByIndex(index);
            if (shareFile != null) {
                String shareFileName = shareFile.getFileName();
                if (!gRequest.getFileName().equalsIgnoreCase(shareFileName)) {
                    String logMsg = "Requested index '" + index + "' with filename '" + shareFileName + "' dosn't match request filename '" + gRequest.getFileName() + "'.";
                    NLogger.debug(UploadEngine.class, (Object)logMsg);
                    uploadState.addToUploadLog(logMsg);
                    shareFile = null;
                }
            } else if (gRequest.getFileName() != null) {
                shareFile = sharedFilesService.getFileByName(gRequest.getFileName());
            }
        }
        return shareFile;
    }
}

