/*
 * Decompiled with CFR 0.152.
 */
package phex.update;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.IntObj;
import phex.common.LongObj;
import phex.common.log.NLogger;
import phex.event.UpdateNotificationListener;
import phex.gui.common.GUIRegistry;
import phex.prefs.core.PhexCorePrefs;
import phex.prefs.core.StatisticPrefs;
import phex.prefs.core.UpdatePrefs;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.utils.IOUtil;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.DUpdateRequest;
import phex.xml.sax.DUpdateResponse;
import phex.xml.sax.XMLBuilder;

public class UpdateCheckRunner
implements Runnable {
    private static final String UPDATE_CHECK_URL = "http://";
    private Throwable updateCheckError;
    private UpdateNotificationListener listener;
    private String releaseVersion;
    private String betaVersion;
    private boolean isBetaInfoShown;

    public UpdateCheckRunner(UpdateNotificationListener updateListener, boolean showBetaInfo) {
        this.listener = updateListener;
        this.isBetaInfoShown = showBetaInfo;
    }

    public static void triggerAutoBackgroundCheck(UpdateNotificationListener updateListener, boolean showBetaInfo) {
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getBetaVersion() {
        return this.betaVersion;
    }

    public Throwable getUpdateCheckError() {
        return this.updateCheckError;
    }

    @Override
    public void run() {
    }

    private void performUpdateCheck() {
        DPhex dPhex;
        try {
            URL url = new URL(UPDATE_CHECK_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", Environment.getPhexVendor());
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            OutputStream outStream = connection.getOutputStream();
            byte[] data = this.buildXMLUpdateRequest();
            if (data == null) {
                throw new IOException("Missing XML update data");
            }
            outStream.write(data);
            if (NLogger.isDebugEnabled(UpdateCheckRunner.class)) {
                NLogger.debug(UpdateCheckRunner.class, (Object)new String(data));
            }
            InputStream inStream = connection.getInputStream();
            if (NLogger.isDebugEnabled(UpdateCheckRunner.class)) {
                byte[] respData = IOUtil.toByteArray(inStream);
                NLogger.debug(UpdateCheckRunner.class, (Object)new String(respData));
                inStream = new ByteArrayInputStream(respData);
            }
            dPhex = XMLBuilder.readDPhexFromStream(inStream);
        }
        catch (MalformedURLException exp) {
            this.updateCheckError = exp;
            NLogger.warn(UpdateCheckRunner.class, (Object)exp, (Throwable)exp);
            assert (false);
            throw new RuntimeException();
        }
        catch (UnknownHostException exp) {
            this.updateCheckError = exp;
            NLogger.warn(UpdateCheckRunner.class, (Object)exp, (Throwable)exp);
            return;
        }
        catch (SocketException exp) {
            this.updateCheckError = exp;
            NLogger.warn(UpdateCheckRunner.class, (Object)exp, (Throwable)exp);
            return;
        }
        catch (IOException exp) {
            this.updateCheckError = exp;
            NLogger.warn(UpdateCheckRunner.class, (Object)exp, (Throwable)exp);
            return;
        }
        UpdatePrefs.LastUpdateCheckTime.set(new Long(System.currentTimeMillis()));
        DUpdateResponse response = dPhex.getUpdateResponse();
        List<DUpdateResponse.VersionType> versionList = response.getVersionList();
        DUpdateResponse.VersionType latestReleaseVersion = null;
        DUpdateResponse.VersionType latestBetaVersion = null;
        for (DUpdateResponse.VersionType currentVersion : versionList) {
            if (currentVersion.isBeta()) {
                if (latestBetaVersion != null && VersionUtils.compare(currentVersion.getId(), latestBetaVersion.getId()) <= 0) continue;
                latestBetaVersion = currentVersion;
                continue;
            }
            if (latestReleaseVersion != null && VersionUtils.compare(currentVersion.getId(), latestReleaseVersion.getId()) <= 0) continue;
            latestReleaseVersion = currentVersion;
        }
        this.betaVersion = "0";
        this.releaseVersion = "0";
        if (latestBetaVersion != null) {
            this.betaVersion = latestBetaVersion.getId();
        }
        if (latestReleaseVersion != null) {
            this.releaseVersion = latestReleaseVersion.getId();
        }
        int releaseCompare = 0;
        int betaCompare = 0;
        betaCompare = VersionUtils.compare(this.betaVersion, VersionUtils.getFullProgramVersion());
        releaseCompare = VersionUtils.compare(this.releaseVersion, VersionUtils.getFullProgramVersion());
        if (releaseCompare <= 0 && betaCompare <= 0) {
            PhexCorePrefs.save(false);
            return;
        }
        betaCompare = VersionUtils.compare(this.betaVersion, UpdatePrefs.LastBetaUpdateCheckVersion.get());
        releaseCompare = VersionUtils.compare(this.releaseVersion, UpdatePrefs.LastUpdateCheckVersion.get());
        int verDiff = VersionUtils.compare(this.betaVersion, this.releaseVersion);
        boolean triggerUpdateNotification = false;
        if (releaseCompare > 0) {
            UpdatePrefs.LastUpdateCheckVersion.set(this.releaseVersion);
            triggerUpdateNotification = true;
        }
        if (betaCompare > 0) {
            UpdatePrefs.LastBetaUpdateCheckVersion.set(this.betaVersion);
            triggerUpdateNotification = true;
        }
        if (verDiff > 0) {
            this.releaseVersion = null;
        } else {
            this.betaVersion = null;
        }
        PhexCorePrefs.save(false);
        if (triggerUpdateNotification) {
            this.fireUpdateNotification();
        }
    }

    private void fireUpdateNotification() {
        this.listener.updateNotification(this);
    }

    private byte[] buildXMLUpdateRequest() {
        try {
            DPhex dPhex = new DPhex();
            DUpdateRequest dRequest = new DUpdateRequest();
            dPhex.setUpdateRequest(dRequest);
            dRequest.setCurrentVersion(VersionUtils.getFullProgramVersion());
            dRequest.setStartupCount(StatisticPrefs.TotalStartupCounter.get());
            dRequest.setLafUsed(GUIRegistry.getInstance().getUsedLAFClass());
            dRequest.setJavaVersion(System.getProperty("java.version"));
            dRequest.setOperatingSystem(SystemUtils.OS_NAME);
            dRequest.setHostid(Servent.getInstance().getServentGuid().toHexString());
            dRequest.setShowBetaInfo(this.isBetaInfoShown);
            dRequest.setLastInfoId(UpdatePrefs.LastShownUpdateInfoId.get());
            String lastCheckVersion = VersionUtils.compare(UpdatePrefs.LastUpdateCheckVersion.get(), UpdatePrefs.LastBetaUpdateCheckVersion.get()) > 0 ? UpdatePrefs.LastUpdateCheckVersion.get() : UpdatePrefs.LastBetaUpdateCheckVersion.get();
            dRequest.setLastCheckVersion(lastCheckVersion);
            StatisticsManager statMgr = StatisticsManager.getInstance();
            StatisticProvider uptimeProvider = statMgr.getStatisticProvider("UptimeProvider");
            dRequest.setAvgUptime(((LongObj)uptimeProvider.getAverageValue()).value);
            StatisticProvider dailyUptimeProvider = statMgr.getStatisticProvider("DailyUptimeProvider");
            dRequest.setDailyAvgUptime(((IntObj)dailyUptimeProvider.getValue()).value);
            StatisticProvider downloadProvider = statMgr.getStatisticProvider("TotalDownloadCountProvider");
            dRequest.setDownloadCount((int)((LongObj)downloadProvider.getValue()).value);
            StatisticProvider uploadProvider = statMgr.getStatisticProvider("TotalUploadCountProvider");
            dRequest.setUploadCount((int)((LongObj)uploadProvider.getValue()).value);
            SharedFilesService sharedFilesService = Servent.getInstance().getSharedFilesService();
            dRequest.setSharedFiles(sharedFilesService.getFileCount());
            dRequest.setSharedSize(sharedFilesService.getTotalFileSizeInKb());
            dRequest.setErrorLog(this.getErrorLogFileTail());
            return XMLBuilder.serializeToBytes(dPhex);
        }
        catch (IOException exp) {
            NLogger.error(UpdateCheckRunner.class, (Object)exp, (Throwable)exp);
            return null;
        }
    }

    private String getErrorLogFileTail() {
        try {
            File logFile = Environment.getInstance().getPhexConfigFile("phex.error.log");
            if (!logFile.exists()) {
                return null;
            }
            RandomAccessFile raf = new RandomAccessFile(logFile, "r");
            long pos = Math.max(raf.length() - 10240L, 0L);
            raf.seek(pos);
            byte[] buffer = new byte[10240];
            int lenRead = raf.read(buffer);
            return new String(buffer, 0, lenRead);
        }
        catch (IOException exp) {
            NLogger.error(UpdateCheckRunner.class, (Object)exp, (Throwable)exp);
            return exp.toString();
        }
    }
}

