/*
 * Decompiled with CFR 0.152.
 */
package phex.udp.hostcache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.common.log.NLogger;
import phex.event.ChangeEvent;
import phex.msg.PongMsg;
import phex.net.repres.PresentationManager;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.udp.hostcache.UdpHostCache;
import phex.udp.hostcache.UdpHostCacheComparator;
import phex.utils.IPUtils;

public class UdpHostCacheContainer {
    private static int MIN_UDP_HOST_CACHE_SIZE = 20;
    public static final UdpHostCacheComparator cacheComparator = new UdpHostCacheComparator();
    private static final List<UdpHostCache> defaultCaches = new ArrayList<UdpHostCache>();
    private final Servent servent;
    private final List<UdpHostCache> functionalUdpCaches;
    private final List<UdpHostCache> generalUdpCaches;
    private final AtomicBoolean isThreadRequestRunning;

    public UdpHostCacheContainer(Servent servent) {
        this.servent = servent;
        this.functionalUdpCaches = new ArrayList<UdpHostCache>();
        this.generalUdpCaches = new ArrayList<UdpHostCache>();
        this.isThreadRequestRunning = new AtomicBoolean(false);
        this.initialize();
        servent.getEventService().processAnnotations(this);
    }

    @EventTopicSubscriber(topic="phex:servent/gnutellaNetwork")
    public void onGnutellaNetworkEvent(String topic, ChangeEvent event) {
        this.saveCachesToFile();
        this.initialize();
    }

    private void initialize() {
        this.functionalUdpCaches.clear();
        this.generalUdpCaches.clear();
        this.loadCachesFromFile();
        this.generalUdpCaches.addAll(defaultCaches);
        NLogger.debug(UdpHostCacheContainer.class, (Object)" Initialized UDP HOST CACHE CONTAINER ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFunctionalCache(UdpHostCache cache) {
        List<UdpHostCache> list = this.generalUdpCaches;
        synchronized (list) {
            if (this.generalUdpCaches.contains(cache)) {
                this.generalUdpCaches.remove(cache);
            }
        }
        cache.resetFailCount();
        NLogger.info(UdpHostCacheContainer.class, (Object)" Adding a UDP Host Cache to the FUNCTIONAL Container");
        return this.addTo(cache, this.functionalUdpCaches);
    }

    public boolean addCache(UdpHostCache cache) {
        int hostCacheCount = this.generalUdpCaches.size() + this.functionalUdpCaches.size();
        if (cache.getFailCount() >= 3 && hostCacheCount > MIN_UDP_HOST_CACHE_SIZE) {
            NLogger.info(UdpHostCacheContainer.class, (Object)(" Udp host cache dropped due to failure count : " + cache));
            return false;
        }
        NLogger.info(UdpHostCacheContainer.class, (Object)" Adding a UDP Host Cache to the GENERAL HOST CACHE CONTAINER ");
        return this.addTo(cache, this.generalUdpCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createPackedHostCaches() {
        int PACKED_CACHES_SIZE = 8;
        StringBuffer packedCaches = new StringBuffer(168);
        List<UdpHostCache> list = this.functionalUdpCaches;
        synchronized (list) {
            Iterator<UdpHostCache> udphc = this.functionalUdpCaches.iterator();
            for (int count = 0; udphc.hasNext() && count < 8; ++count) {
                UdpHostCache cache = udphc.next();
                DestAddress address = cache.getHostAddress();
                String ipString = address.getFullHostName();
                packedCaches.append(ipString);
                packedCaches.append("\n");
            }
        }
        return packedCaches.toString();
    }

    public void catchHosts(PongMsg pongMsg) {
        UdpHostCache cache;
        Set<UdpHostCache> udpHostCaches = pongMsg.getUdpHostCaches();
        if (udpHostCaches != null) {
            for (UdpHostCache cache2 : udpHostCaches) {
                this.addCache(cache2);
            }
        }
        if ((cache = pongMsg.getUdpHostCache()) != null) {
            this.addFunctionalCache(cache);
        }
    }

    public synchronized void invokeQueryCachesRequest() {
        if (!this.isThreadRequestRunning.compareAndSet(false, true)) {
            return;
        }
        QueryCachesRunner runner = new QueryCachesRunner();
        ThreadPool.getInstance().addJob(runner, "UdpHostCacheQuery-" + Integer.toHexString(runner.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryMoreHosts() {
        UdpHostCache cache;
        List<UdpHostCache> list;
        int i;
        int NO_OF_CACHES_TO_PING = 3;
        int pingedCacheCount = 0;
        for (i = 0; i < 2; ++i) {
            list = this.functionalUdpCaches;
            synchronized (list) {
                if (this.functionalUdpCaches.isEmpty()) {
                    break;
                }
                cache = this.functionalUdpCaches.remove(0);
                if (cache != null) {
                    this.queryCache(cache);
                    ++pingedCacheCount;
                }
                continue;
            }
        }
        for (i = pingedCacheCount; i <= 3; ++i) {
            list = this.generalUdpCaches;
            synchronized (list) {
                if (this.generalUdpCaches.isEmpty()) {
                    break;
                }
                cache = this.generalUdpCaches.remove(0);
                if (cache != null) {
                    this.queryCache(cache);
                }
                continue;
            }
        }
    }

    private void queryCache(UdpHostCache cache) {
        NLogger.info(UdpHostCacheContainer.class, (Object)(" Pinging UDP Host Cache :" + cache));
        cache.pingCache();
        cache.incrementFailCount();
        this.addCache(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCachesFromFile() {
        try {
            File file = this.servent.getGnutellaNetwork().getUdpHostCacheFile();
            if (!file.exists()) {
                NLogger.debug(UdpHostCacheContainer.class, (Object)"No UDP host cache file found.");
                return;
            }
            PhexSecurityManager securityMgr = PhexSecurityManager.getInstance();
            BufferedReader br = new BufferedReader(new FileReader(file));
            List<UdpHostCache> list = this.generalUdpCaches;
            synchronized (list) {
                String line;
                block10: while ((line = br.readLine()) != null) {
                    DestAddress hostCacheAdr;
                    if (line.startsWith("#")) continue;
                    try {
                        hostCacheAdr = PresentationManager.getInstance().createHostAddress(line, 6346);
                    }
                    catch (MalformedDestAddressException e) {
                        NLogger.warn(UdpHostCacheContainer.class, (Object)(" Could not create cache to add to the container from the host string : " + line), (Throwable)e);
                        continue;
                    }
                    AccessType access = securityMgr.controlHostAddressAccess(hostCacheAdr);
                    switch (access) {
                        case ACCESS_DENIED: 
                        case ACCESS_STRONGLY_DENIED: {
                            continue block10;
                        }
                    }
                    if (IPUtils.isPortInUserInvalidList(hostCacheAdr)) continue;
                    UdpHostCache cache = new UdpHostCache(hostCacheAdr);
                    this.addCache(cache);
                }
            }
            br.close();
        }
        catch (IOException e) {
            NLogger.warn(UdpHostCacheContainer.class, (Object)" Loading Udp Host Caches  from file FAILED ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTo(UdpHostCache cache, List<UdpHostCache> cacheContainer) {
        List<UdpHostCache> list = cacheContainer;
        synchronized (list) {
            if (!cacheContainer.contains(cache)) {
                cacheContainer.add(cache);
                Collections.sort(cacheContainer, cacheComparator);
                NLogger.info(UdpHostCacheContainer.class, (Object)(" Added UdpHostCache  : " + cache));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(UdpHostCache cache, List<UdpHostCache> cacheContainer) {
        List<UdpHostCache> list = cacheContainer;
        synchronized (list) {
            if (cacheContainer.contains(cache)) {
                cacheContainer.remove(cache);
            }
            cacheContainer.add(cache);
            Collections.sort(cacheContainer, cacheComparator);
            NLogger.info(UdpHostCacheContainer.class, (Object)(" Added UdpHostCache  : " + cache));
            return true;
        }
    }

    public void saveCachesToFile() {
        try {
            File file = this.servent.getGnutellaNetwork().getUdpHostCacheFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            this.writeCachesToFile(writer, this.functionalUdpCaches);
            this.writeCachesToFile(writer, this.generalUdpCaches);
            writer.flush();
            writer.close();
        }
        catch (IOException exp) {
            NLogger.warn(UdpHostCacheContainer.class, (Object)" Saving Udp Host Caches  to file FAILED ", (Throwable)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCachesToFile(BufferedWriter writer, List<UdpHostCache> cacheContainer) throws IOException {
        List<UdpHostCache> list = cacheContainer;
        synchronized (list) {
            for (UdpHostCache cache : cacheContainer) {
                DestAddress address = cache.getHostAddress();
                String ipString = address.getFullHostName();
                writer.write(ipString);
                writer.newLine();
            }
        }
    }

    private final class QueryCachesRunner
    implements Runnable {
        private QueryCachesRunner() {
        }

        @Override
        public void run() {
            UdpHostCacheContainer.this.queryMoreHosts();
            UdpHostCacheContainer.this.isThreadRequestRunning.set(false);
        }
    }
}

