/*
 * Decompiled with CFR 0.152.
 */
package phex.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import phex.common.IntObj;
import phex.common.ThreadTracking;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongFactory;
import phex.msg.PongMsg;
import phex.net.repres.PresentationManager;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.share.SharedFilesService;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.udp.UdpGuidRoutingTable;
import phex.udp.UdpMsgQueue;
import phex.utils.HexConverter;

public class UdpMessageEngine {
    public static final int MAX_PACKET_SIZE = 1024;
    public static final int MAX_RECV_BUFFER_SIZE = 16384;
    private DatagramSocket udpSocket;
    private UdpMsgQueue sendQueue;
    private UdpGuidRoutingTable pingRoutingTable;
    private final Servent servent;
    private final HostManager hostService;
    private final PongFactory pongFactory;
    private final PhexSecurityManager securityManager;
    private final SharedFilesService sharedFilesService;

    public UdpMessageEngine(Servent servent, HostManager hostService, PongFactory pongFactory, SharedFilesService sharedFilesService) {
        this.servent = servent;
        this.hostService = hostService;
        this.pongFactory = pongFactory;
        this.sharedFilesService = sharedFilesService;
        this.sendQueue = new UdpMsgQueue();
        this.securityManager = PhexSecurityManager.getInstance();
        this.pingRoutingTable = new UdpGuidRoutingTable(30000L);
        int port = servent.getLocalAddress().getPort();
        try {
            this.udpSocket = new DatagramSocket(port);
            this.udpSocket.setReceiveBufferSize(16384);
        }
        catch (SocketException e) {
            NLogger.warn(UdpMessageEngine.class, (Object)(" Couldnt bind to port " + port), (Throwable)e);
            return;
        }
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, new Reciever(), "UDP Message Receiver");
        thread.start();
        thread = new Thread(ThreadTracking.rootThreadGroup, new Sender(), "UDP Message Sender");
        thread.start();
    }

    public void addMessageToSend(Message msg, DestAddress destinationAddr) {
    }

    private DatagramPacket getDatagramToSend() {
        UdpMsgQueue.QueueElement element = this.sendQueue.removeMessage();
        Message msg = element.getMsg();
        DestAddress address = element.getAddress();
        byte[] data = null;
        if (msg instanceof PingMsg) {
            GUID guid = msg.getHeader().getMsgID();
            if (!this.pingRoutingTable.checkAndAddRouting(guid, address)) {
                NLogger.warn(UdpMessageEngine.class, (Object)(" ping with duplicate guid not sent " + guid + " for message : " + msg));
                return null;
            }
            PingMsg ping = (PingMsg)msg;
            data = ping.getBytes();
            NLogger.debug(UdpMessageEngine.class, (Object)(" guid : " + guid + " successfully added to routing table for " + " udp ping : \n " + msg));
        }
        if (msg instanceof PongMsg) {
            PongMsg pong = (PongMsg)msg;
            data = pong.getbytes();
        }
        if (data == null) {
            return null;
        }
        try {
            IpAddress ipAddress = address.getIpAddress();
            InetAddress ipAddr = ipAddress != null ? InetAddress.getByAddress(ipAddress.getHostIP()) : InetAddress.getByName(address.getHostName());
            int port = address.getPort();
            DatagramPacket packet = new DatagramPacket(data, data.length, ipAddr, port);
            NLogger.debug(UdpMessageEngine.class, (Object)(" created udp datagram for msg " + msg + " \n to " + ipAddr));
            return packet;
        }
        catch (UnknownHostException e) {
            NLogger.warn(UdpMessageEngine.class, (Object)(" Could not create datagram  from message : " + msg), (Throwable)e);
            return null;
        }
    }

    public DatagramPacket readMessage() {
        byte[] data = new byte[1024];
        DatagramPacket packet = new DatagramPacket(data, data.length);
        try {
            this.udpSocket.receive(packet);
            return packet;
        }
        catch (IOException e) {
            NLogger.warn(UdpMessageEngine.class, (Object)(" Could not read from udp socket " + this.udpSocket.getLocalSocketAddress()), (Throwable)e);
            return null;
        }
    }

    private void handlePing(MsgHeader header, byte[] body, Host fromHost) {
        try {
            if (header.getHopsTaken() > 1) {
                throw new InvalidMessageException("Udp Ping traveled more then 1 hop.");
            }
            PingMsg udpPing = PingMsg.createUdpPingMsg(header, body, 23, fromHost);
            NLogger.debug(UdpMessageEngine.class, (Object)(" Recieved Udp Ping Msg From " + fromHost + " : " + udpPing));
            this.respondToPing(udpPing);
        }
        catch (InvalidMessageException exp) {
            this.dropMessage(header, body, fromHost, "Invalid message: " + exp.getMessage());
            NLogger.warn(UdpMessageEngine.class, (Object)exp, (Throwable)exp);
        }
    }

    private void respondToPing(PingMsg udpPing) {
        StatisticsManager statMgr = StatisticsManager.getInstance();
        StatisticProvider uptimeProvider = statMgr.getStatisticProvider("DailyUptimeProvider");
        int avgDailyUptime = ((IntObj)uptimeProvider.getValue()).intValue();
        int shareFileCount = this.sharedFilesService.getFileCount();
        int shareFileSize = this.sharedFilesService.getTotalFileSizeInKb();
        DestAddress localAddress = this.servent.getLocalAddress();
        boolean isUdpHostCache = this.servent.isUdpHostCache();
        PongMsg pong = this.pongFactory.createUdpPongMsg(udpPing, localAddress, isUdpHostCache, avgDailyUptime, shareFileCount, shareFileSize, this.servent.isUltrapeer(), this.hostService.getCaughtHostsContainer(), this.hostService.getUhcContainer());
        DestAddress address = udpPing.getHeader().getFromHost().getHostAddress();
        this.addMessageToSend(pong, address);
        NLogger.info(UdpMessageEngine.class, (Object)("added to send queue Udp Pong :" + pong + " \n \t to " + address));
    }

    private void handlePong(MsgHeader header, byte[] data, Host fromHost) {
        boolean isNew;
        GUID guid = header.getMsgID();
        DestAddress address = this.pingRoutingTable.getAndRemoveRouting(guid);
        if (address == null) {
            NLogger.warn(UdpMessageEngine.class, (Object)(" Recieved Udp Pong  with Guid not found in the routing table : " + header + " \n \t Ignoring pong"));
            return;
        }
        PongMsg udpPong = null;
        try {
            if (header.getHopsTaken() > 1) {
                throw new InvalidMessageException("Udp Ping traveled more then 1 hop.");
            }
            udpPong = PongFactory.createUdpPongMsg(header, data, 23, fromHost);
            NLogger.debug(UdpMessageEngine.class, (Object)(" Recieved Udp Pong Msg From " + fromHost + " : " + udpPong));
        }
        catch (InvalidMessageException exp) {
            this.dropMessage(header, data, fromHost, "Invalid message: " + exp.getMessage());
            NLogger.warn(UdpMessageEngine.class, (Object)exp, (Throwable)exp);
            return;
        }
        AccessType access = this.securityManager.controlHostAddressAccess(udpPong.getPongAddress());
        if (access == AccessType.ACCESS_STRONGLY_DENIED) {
            return;
        }
        if (access == AccessType.ACCESS_GRANTED && (isNew = this.hostService.catchHosts(udpPong))) {
            Servent.getInstance().getMessageService().addPongToCache(udpPong);
        }
    }

    private void dropMessage(MsgHeader header, byte[] body, Host fromHost, String reason) {
        NLogger.info(UdpMessageEngine.class, (Object)("Dropping UDP message: " + reason + " from: " + fromHost));
        if (NLogger.isDebugEnabled(UdpMessageEngine.class)) {
            NLogger.debug(UdpMessageEngine.class, (Object)("Header: " + header.toString() + " Body: " + " (" + HexConverter.toHexString(body, 0, header.getDataLength()) + ")."));
        }
    }

    class Reciever
    implements Runnable {
        Reciever() {
        }

        @Override
        public void run() {
            while (true) {
                DatagramPacket packet;
                if ((packet = UdpMessageEngine.this.readMessage()) == null) {
                    continue;
                }
                byte[] packetData = packet.getData();
                int pktDataLength = packet.getLength();
                byte[] ip = packet.getAddress().getAddress();
                int port = packet.getPort();
                DestAddress address = PresentationManager.getInstance().createHostAddress(ip, port);
                if (pktDataLength < 23) continue;
                Host fromHost = UdpMessageEngine.this.hostService.getNetworkHostsContainer().getNetworkHost(address);
                if (fromHost == null) {
                    fromHost = new Host(address);
                }
                MsgHeader header = null;
                try {
                    header = MsgHeader.createMsgHeader(packetData, 0);
                    if (header.getDataLength() > pktDataLength - 23) {
                        NLogger.warn(Reciever.class, (Object)" Msg Header Data length is invalid ");
                    }
                    header.countHop();
                    switch (header.getPayload()) {
                        case 0: {
                            NLogger.debug(Reciever.class, (Object)(" Recvd Ping from : " + address));
                            UdpMessageEngine.this.handlePing(header, packetData, fromHost);
                            break;
                        }
                        case 1: {
                            NLogger.debug(Reciever.class, (Object)(" Recvd Pong from : " + address));
                            UdpMessageEngine.this.handlePong(header, packetData, fromHost);
                            break;
                        }
                        default: {
                            NLogger.debug(Reciever.class, (Object)(" Recvd unrecognized Msg from : " + address));
                            break;
                        }
                    }
                    continue;
                }
                catch (InvalidMessageException exp) {
                    NLogger.warn(Reciever.class, (Object)("Invalid message: " + exp.getMessage()), (Throwable)exp);
                    continue;
                }
                catch (Exception e) {
                    NLogger.warn(Reciever.class, (Object)" Failed to create udp pong from datagram ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        @Override
        public void run() {
            while (true) {
                DatagramPacket packet;
                if ((packet = UdpMessageEngine.this.getDatagramToSend()) == null) {
                    continue;
                }
                try {
                    UdpMessageEngine.this.udpSocket.send(packet);
                    continue;
                }
                catch (IOException e) {
                    NLogger.warn(Sender.class, (Object)("Sending udp message " + packet + "failed "), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

