/*
 * Decompiled with CFR 0.152.
 */
package phex.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import phex.common.address.AddressUtils;

public class Ip2CountryDBBuilder {
    private static final String APNIC = "ftp://ftp.apnic.net/pub/stats/apnic/delegated-apnic-latest";
    private static final String RIPE = "ftp://ftp.apnic.net/pub/stats/ripe-ncc/delegated-ripencc-latest";
    private static final String ARIN = "ftp://ftp.apnic.net/pub/stats/arin/delegated-arin-latest";
    private static final String LACNIC = "ftp://ftp.apnic.net/pub/stats/lacnic/delegated-lacnic-latest";
    private static List<IpCountryRange> dataList;

    public static void main(String[] args) throws Exception {
        dataList = new ArrayList<IpCountryRange>();
        String[] rirs = new String[]{LACNIC, APNIC, RIPE, ARIN};
        for (int i = 0; i < rirs.length; ++i) {
            System.out.println("Loading " + rirs[i]);
            URL url = new URL(rirs[i]);
            URLConnection connection = url.openConnection();
            InputStream inputStream = connection.getInputStream();
            Ip2CountryDBBuilder.readData(inputStream);
            System.out.println("Total data read: " + dataList.size());
            inputStream.close();
        }
        Collections.sort(dataList);
        System.out.println("before size: " + dataList.size());
        Ip2CountryDBBuilder.consolidateList();
        System.out.println("after size: " + dataList.size());
        Ip2CountryDBBuilder.writeToOutputFile("ip2country.csv");
    }

    private static void writeToOutputFile(String fileName) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter("src/main/java/phex/resources/" + fileName));
        for (IpCountryRange range : dataList) {
            writer.write("" + range.from + "," + range.to + "," + range.countryCode + "\n");
        }
        writer.close();
    }

    private static void consolidateList() {
        ArrayList<IpCountryRange> consolidatedList = new ArrayList<IpCountryRange>();
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            IpCountryRange range = dataList.get(i);
            for (int j = i + 1; j < size; ++j) {
                IpCountryRange nextRange = dataList.get(j);
                if (!range.countryCode.equals(nextRange.countryCode) || range.to + 1L != nextRange.from) break;
                range.to = range.to + nextRange.to - nextRange.from + 1L;
                ++i;
            }
            consolidatedList.add(range);
        }
        dataList = consolidatedList;
    }

    private static void readData(InputStream inputStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("2") || line.endsWith("summary")) continue;
            StringTokenizer tokenizer = new StringTokenizer(line, "|");
            tokenizer.nextToken();
            String countryCode = tokenizer.nextToken();
            String type = tokenizer.nextToken();
            if (!type.equals("ipv4")) continue;
            String start = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            long rangeValue = Long.parseLong(value);
            byte[] ip = AddressUtils.parseIP(start);
            int v1 = ip[3] & 0xFF;
            int v2 = ip[2] << 8 & 0xFF00;
            int v3 = ip[1] << 16 & 0xFF0000;
            int v4 = ip[0] << 24;
            long ipValue = (long)(v4 | v3 | v2 | v1) & 0xFFFFFFFFL;
            long toIpValue = ipValue + rangeValue - 1L;
            IpCountryRange range = new IpCountryRange(ipValue, toIpValue, countryCode);
            dataList.add(range);
        }
    }

    private static class IpCountryRange
    implements Comparable<IpCountryRange> {
        long from;
        long to;
        String countryCode;

        public IpCountryRange(long from, long to, String cc) {
            this.from = from;
            this.to = to;
            this.countryCode = cc;
        }

        public String toString() {
            return String.valueOf(this.from) + " - " + String.valueOf(this.to) + " " + this.countryCode;
        }

        @Override
        public int compareTo(IpCountryRange range) {
            if (this.from > range.from) {
                return 1;
            }
            if (this.from < range.from) {
                return -1;
            }
            return 0;
        }
    }
}

