/*
 * Decompiled with CFR 0.152.
 */
package phex.thex;

import com.bitzi.util.Base32;
import com.bitzi.util.Tiger;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;
import phex.thex.Thex;

public class TigerTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    private static final double fblockSize = 1024.0;
    private static final int HASHSIZE = 24;
    private final byte[] buffer = new byte[1024];
    int count = 0;
    private int bufferOffset = 0;
    private int serializationOffset = 0;
    private int serializationLeavesOffset = 0;
    private long byteCount = 0L;
    private MessageDigest tiger;
    private Vector nodes;
    private long fileSize;
    private byte[] serialization = null;
    private Thex t = null;
    private int levelsLeft = 0;
    private boolean check = false;

    public TigerTree(long filesize, int serializSize, int levelsLeft) throws NoSuchAlgorithmException {
        super("TigerTree");
        this.fileSize = filesize;
        this.levelsLeft = levelsLeft;
        int numberLeafs = (int)Math.ceil((double)this.fileSize / 1024.0);
        this.serialization = new byte[serializSize];
        this.t = new Thex();
        this.tiger = new Tiger();
        this.nodes = new Vector();
    }

    public TigerTree(int levelsLeft, int digestSize, int serializSize, Vector nodes, boolean check) throws NoSuchAlgorithmException {
        super("TigerTree");
        this.levelsLeft = levelsLeft;
        this.nodes = nodes;
        this.check = true;
        this.serialization = new byte[serializSize];
        this.t = new Thex();
        this.tiger = new Tiger();
    }

    public TigerTree() throws NoSuchAlgorithmException {
        super("TigerTree");
        this.tiger = new Tiger();
        this.nodes = new Vector();
    }

    public byte[] calculate(byte[] buf) {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(buf, 0, 0);
        byte[] dig = this.tiger.digest();
        return dig;
    }

    @Override
    protected int engineGetDigestLength() {
        return 24;
    }

    protected byte[] getSerialization() {
        return this.serialization;
    }

    @Override
    protected void engineUpdate(byte in) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = in;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    @Override
    protected void engineUpdate(byte[] in, int offset, int length) {
        int remaining;
        this.byteCount += (long)length;
        while (length >= (remaining = 1024 - this.bufferOffset)) {
            System.arraycopy(in, offset, this.buffer, this.bufferOffset, remaining);
            this.bufferOffset += remaining;
            this.blockUpdate();
            length -= remaining;
            offset += remaining;
            this.bufferOffset = 0;
        }
        System.arraycopy(in, offset, this.buffer, this.bufferOffset, length);
        this.bufferOffset += length;
    }

    @Override
    protected byte[] engineDigest() {
        byte[] hash = new byte[24];
        try {
            this.engineDigest(hash, 0, 24);
        }
        catch (DigestException e) {
            return null;
        }
        return hash;
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 24) {
            throw new DigestException();
        }
        if (!this.check) {
            this.blockUpdate();
        }
        int rows = 0;
        while (this.nodes.size() > 1) {
            if (this.check && ++rows > this.levelsLeft) {
                this.t.setSerializationByte(this.serialization);
                return 24;
            }
            Vector<byte[]> newNodes = new Vector<byte[]>();
            Enumeration iter = this.nodes.elements();
            while (iter.hasMoreElements()) {
                byte[] left = (byte[])iter.nextElement();
                if (iter.hasMoreElements()) {
                    byte[] right = (byte[])iter.nextElement();
                    this.tiger.reset();
                    this.tiger.update((byte)1);
                    this.tiger.update(left);
                    this.tiger.update(right);
                    byte[] dig = this.tiger.digest();
                    newNodes.addElement(dig);
                    if (this.levelsLeft == -1 || rows != this.levelsLeft) continue;
                    byte[] digs = dig;
                    System.arraycopy(digs, 0, this.serialization, this.serializationOffset, digs.length);
                    this.serializationOffset += digs.length;
                    continue;
                }
                byte[] obj = left;
                newNodes.addElement(obj);
                if (this.levelsLeft == -1 || rows != this.levelsLeft) continue;
                byte[] digs = obj;
                System.arraycopy(digs, 0, this.serialization, this.serializationOffset, digs.length);
                this.serializationOffset += digs.length;
            }
            this.nodes = newNodes;
        }
        byte[] root = (byte[])this.nodes.elementAt(0);
        System.arraycopy(root, 0, buf, offset, 24);
        this.engineReset();
        if (this.t != null) {
            this.t.setHashSize(24);
            this.t.setSerialization(Base32.encode(this.serialization));
            this.t.setRoot(Base32.encode(root));
        }
        return 24;
    }

    public Thex getThex() {
        return this.t;
    }

    @Override
    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes = new Vector();
        this.tiger.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.tiger.reset();
        this.tiger.update((byte)0);
        this.tiger.update(this.buffer, 0, this.bufferOffset);
        if (this.bufferOffset == 0 & this.nodes.size() > 0) {
            return;
        }
        byte[] dig = this.tiger.digest();
        this.nodes.addElement(dig);
        ++this.count;
        if (this.levelsLeft == -1) {
            byte[] digst = dig;
            System.arraycopy(digst, 0, this.serialization, this.serializationLeavesOffset, digst.length);
            this.serializationLeavesOffset += digst.length;
        }
    }
}

