/*
 * Decompiled with CFR 0.152.
 */
package phex.thex;

import com.bitzi.util.Tiger;
import com.bitzi.util.TigerTree;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileInputStream;
import phex.common.log.NLogger;
import phex.download.ThexVerificationData;
import phex.prefs.core.LibraryPrefs;
import phex.share.ShareFile;
import phex.thex.ShareFileThexData;
import phex.thex.ThexCalculationWorker;
import phex.utils.IOUtil;

public class TTHashCalcUtils {
    private static final transient byte MERKLE_IH_PREFIX = 1;
    private static final int THEX_BLOCK_SIZE = 1024;
    private static final int HASH_SIZE = 24;

    public static void calculateShareFileThexData(ShareFile shareFile) throws IOException {
        if (shareFile.getThexData(null) != null) {
            return;
        }
        long fileSize = shareFile.getFileSize();
        int levels = TTHashCalcUtils.getTreeLevels(fileSize);
        int nodeSize = TTHashCalcUtils.getTreeNodeSize(fileSize, levels);
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(shareFile.getSystemFile()));
        List<byte[]> lowestLevelNodes = TTHashCalcUtils.calculateTigerTreeNodes(nodeSize, fileSize, inStream);
        List<List<byte[]>> merkleTreeNodes = TTHashCalcUtils.calculateMerkleParentNodes(lowestLevelNodes);
        byte[] rootHash = merkleTreeNodes.get(0).get(0);
        int depth = merkleTreeNodes.size() - 1;
        ShareFileThexData data = new ShareFileThexData(rootHash, lowestLevelNodes, depth);
        shareFile.setThexData(data);
    }

    public static int getTreeLevels(long fileSize) {
        if (fileSize < 262144L) {
            return 0;
        }
        if (fileSize < 524288L) {
            return 1;
        }
        if (fileSize < 0x100000L) {
            return 2;
        }
        if (fileSize < 0x200000L) {
            return 3;
        }
        if (fileSize < 0x400000L) {
            return 4;
        }
        if (fileSize < 0x800000L) {
            return 5;
        }
        if (fileSize < 0x1000000L) {
            return 6;
        }
        if (fileSize < 0x2000000L) {
            return 7;
        }
        if (fileSize < 0x4000000L) {
            return 8;
        }
        if (fileSize < 0x10000000L) {
            return 9;
        }
        if (fileSize < 0x40000000L) {
            return 10;
        }
        return 11;
    }

    public static int getTreeNodeSize(long fileSize, int depth) {
        int nodes = (int)Math.pow(2.0, depth);
        int fileNodeSize = (int)Math.ceil((double)fileSize / (double)nodes);
        byte pow = IOUtil.calculateCeilLog2(fileNodeSize);
        int nodeSize = (int)Math.pow(2.0, pow);
        return nodeSize;
    }

    private static List<byte[]> calculateTigerTreeNodes(int nodeSize, long fileSize, InputStream inStream) throws IOException {
        int thexCalculationMode = LibraryPrefs.ThexCalculationMode.get();
        int nodeCount = (int)Math.ceil((double)fileSize / (double)nodeSize);
        ArrayList<byte[]> nodeList = new ArrayList<byte[]>(nodeCount);
        TigerTree tigerTreeDigest = new TigerTree();
        long totalRead = 0L;
        int readCount = 0;
        byte[] buffer = new byte[131072];
        while (totalRead < fileSize && readCount != -1) {
            tigerTreeDigest.reset();
            int nodePos = 0;
            long start = System.currentTimeMillis();
            while (nodePos < nodeSize && (readCount = inStream.read(buffer)) != -1) {
                tigerTreeDigest.update(buffer, 0, readCount);
                nodePos += readCount;
                totalRead += (long)readCount;
                try {
                    long end = System.currentTimeMillis();
                    Thread.sleep((end - start) * (long)thexCalculationMode);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Hashing file interrupted.");
                }
                start = System.currentTimeMillis();
            }
            nodeList.add(tigerTreeDigest.digest());
            if (readCount != -1 || totalRead == fileSize) continue;
            NLogger.error(ThexCalculationWorker.class, (Object)"Hashing file failed.");
            throw new IOException("Hashing file failed.");
        }
        return nodeList;
    }

    public static List<List<byte[]>> calculateMerkleParentNodes(List<byte[]> childNodes) {
        ArrayList<List<byte[]>> merkleTreeNodes = new ArrayList<List<byte[]>>();
        merkleTreeNodes.add(Collections.unmodifiableList(childNodes));
        List<byte[]> tmpNodes = childNodes;
        while (tmpNodes.size() > 1) {
            Tiger md = new Tiger();
            int size = (int)Math.ceil((double)tmpNodes.size() / 2.0);
            ArrayList<byte[]> parentNodes = new ArrayList<byte[]>(size);
            Iterator<byte[]> iterator = tmpNodes.iterator();
            while (iterator.hasNext()) {
                byte[] left = iterator.next();
                if (iterator.hasNext()) {
                    byte[] right = iterator.next();
                    md.reset();
                    md.update((byte)1);
                    md.update(left, 0, left.length);
                    md.update(right, 0, right.length);
                    byte[] result = md.digest();
                    parentNodes.add(result);
                    continue;
                }
                parentNodes.add(left);
            }
            merkleTreeNodes.add(0, parentNodes);
            tmpNodes = parentNodes;
        }
        return merkleTreeNodes;
    }

    public static List<List<byte[]>> resolveMerkleNodes(byte[] data, long fileSize) throws IOException {
        int levels = TTHashCalcUtils.getTreeLevels(fileSize);
        ArrayList<byte[]> hashList = new ArrayList<byte[]>();
        if (data.length % 24 != 0) {
            throw new IOException("invalid hash tree size.");
        }
        int i = 0;
        while (i + 24 <= data.length) {
            byte[] hash = new byte[24];
            System.arraycopy(data, i, hash, 0, 24);
            hashList.add(hash);
            i += 24;
        }
        ArrayList<List<byte[]>> merkleTreeNodes = new ArrayList<List<byte[]>>(levels + 1);
        ArrayList<byte[]> parentRow = null;
        ArrayList<Object> currentRow = null;
        Iterator hashListIterator = hashList.iterator();
        if (!hashListIterator.hasNext()) {
            throw new IOException("missing root hash.");
        }
        byte[] root = (byte[])hashListIterator.next();
        parentRow = new ArrayList<byte[]>(1);
        parentRow.add(root);
        merkleTreeNodes.add(Collections.unmodifiableList(parentRow));
        currentRow = new ArrayList<byte[]>(2);
        int rowIndex = 1;
        boolean verified = true;
        while (rowIndex <= levels && hashListIterator.hasNext()) {
            verified = false;
            byte[] hash = (byte[])hashListIterator.next();
            currentRow.add(hash);
            if (currentRow.size() > parentRow.size() * 2) {
                throw new IOException("hash tree is corrupt.");
            }
            if (currentRow.size() != parentRow.size() * 2 - 1 && currentRow.size() != parentRow.size() * 2 || !TTHashCalcUtils.verifyMerkleChildToParent(currentRow, parentRow)) continue;
            parentRow = currentRow;
            merkleTreeNodes.add(Collections.unmodifiableList(currentRow));
            if (++rowIndex <= levels && hashListIterator.hasNext()) {
                currentRow = new ArrayList(parentRow.size() * 2);
            }
            verified = true;
        }
        if (!verified) {
            throw new IOException("hash tree is corrupt.");
        }
        return merkleTreeNodes;
    }

    private static boolean verifyMerkleChildToParent(List<byte[]> childNodes, List<byte[]> expectedParentNodes) {
        List<byte[]> parentNodeListOfChilds = TTHashCalcUtils.calculateMerkleParentRow(childNodes);
        if (parentNodeListOfChilds.size() != expectedParentNodes.size()) {
            return false;
        }
        int size = expectedParentNodes.size();
        for (int i = 0; i < size; ++i) {
            byte[] expectedNodes;
            byte[] nodes = parentNodeListOfChilds.get(i);
            if (Arrays.equals(nodes, expectedNodes = expectedParentNodes.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<byte[]> calculateMerkleParentRow(List<byte[]> childNodes) {
        Tiger md = new Tiger();
        int size = childNodes.size();
        ArrayList<byte[]> parentRow = new ArrayList<byte[]>((int)Math.ceil((double)size / 2.0));
        Iterator<byte[]> childNodesIterator = childNodes.iterator();
        while (childNodesIterator.hasNext()) {
            byte[] leftNode = childNodesIterator.next();
            if (!childNodesIterator.hasNext()) {
                parentRow.add(leftNode);
                continue;
            }
            byte[] rightNode = childNodesIterator.next();
            md.reset();
            md.update((byte)1);
            md.update(leftNode, 0, leftNode.length);
            md.update(rightNode, 0, rightNode.length);
            byte[] result = md.digest();
            parentRow.add(result);
        }
        return parentRow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifyTigerTreeHash(ThexVerificationData.ThexData thexData, ManagedFile managedFile, long offset, long length) {
        ManagedFileInputStream inStream = new ManagedFileInputStream(managedFile, offset);
        int thexCalculationMode = LibraryPrefs.ThexCalculationMode.get();
        TigerTree tigerTreeDigest = new TigerTree();
        int readCount = 0;
        byte[] buffer = new byte[131072];
        try {
            for (long totalRead = 0L; totalRead < length && (readCount = inStream.read(buffer)) != -1; totalRead += (long)readCount) {
                long start = System.currentTimeMillis();
                tigerTreeDigest.update(buffer, 0, readCount);
                try {
                    long end = System.currentTimeMillis();
                    Thread.sleep((end - start) * (long)thexCalculationMode);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Hashing file interrupted.");
                }
            }
        }
        catch (IOException exp) {
            return false;
        }
        byte[] hash = tigerTreeDigest.digest();
        byte[] expected = thexData.getNodeHash((int)(offset / (long)thexData.getNodeSize()));
        return Arrays.equals(hash, expected);
    }
}

