/*
 * Decompiled with CFR 0.152.
 */
package phex.thex;

import com.bitzi.util.Base32;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import phex.common.log.NLogger;
import phex.thex.TTHashCalcUtils;

public class ShareFileThexData {
    private String rootHash;
    private List<byte[]> lowestLevelNodes;
    private int treeDepth;

    public ShareFileThexData(byte[] rootHash, List<byte[]> lowestLevelNodes, int depth) {
        this.rootHash = Base32.encode(rootHash);
        this.lowestLevelNodes = lowestLevelNodes;
        this.treeDepth = depth;
    }

    public ShareFileThexData(String rootHash, String xjbLowestLevelNodes, int depth) {
        this.rootHash = rootHash;
        this.lowestLevelNodes = ShareFileThexData.parseXJBLowestLevelNodes(xjbLowestLevelNodes);
        this.treeDepth = depth;
    }

    public String getRootHash() {
        return this.rootHash;
    }

    public int getTreeDepth() {
        return this.treeDepth;
    }

    public byte[] getSerializedTreeNodes() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        List<List<byte[]>> allNodes = TTHashCalcUtils.calculateMerkleParentNodes(this.lowestLevelNodes);
        Iterator<List<byte[]>> iterator = allNodes.iterator();
        try {
            while (iterator.hasNext()) {
                Iterator<byte[]> subIterator = iterator.next().iterator();
                while (subIterator.hasNext()) {
                    outStream.write(subIterator.next());
                }
            }
        }
        catch (IOException exp) {
            NLogger.error(ShareFileThexData.class, (Object)exp, (Throwable)exp);
            throw new RuntimeException(exp);
        }
        return outStream.toByteArray();
    }

    public String getXJBLowestLevelNodes() {
        Iterator<byte[]> iterator = this.lowestLevelNodes.iterator();
        StringBuffer xjbString = new StringBuffer();
        while (iterator.hasNext()) {
            byte[] nodeData = iterator.next();
            String node = new String(Base64.encodeBase64(nodeData));
            xjbString.append(node);
            xjbString.append("-");
        }
        return xjbString.toString();
    }

    public void updateFromCache(String rootHash, String xjbLowestLevelNodes, int depth) {
        this.rootHash = rootHash;
        this.lowestLevelNodes = ShareFileThexData.parseXJBLowestLevelNodes(xjbLowestLevelNodes);
        this.treeDepth = depth;
    }

    private static List<byte[]> parseXJBLowestLevelNodes(String xjbString) {
        StringTokenizer tokenizer = new StringTokenizer(xjbString, "-");
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        while (tokenizer.hasMoreTokens()) {
            String node = tokenizer.nextToken();
            byte[] nodeData = Base64.decodeBase64(node.getBytes());
            list.add(nodeData);
        }
        return list;
    }
}

