/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.LongObj;
import phex.common.format.TimeFormatUtils;
import phex.prefs.core.StatisticPrefs;
import phex.statistic.StatisticProvider;

public class UptimeStatisticProvider
implements StatisticProvider {
    private long startTime;
    private LongObj valueObj = new LongObj();
    private LongObj avgObj = new LongObj();
    private LongObj maxObj = new LongObj(StatisticPrefs.MaximalUptime.get());

    public UptimeStatisticProvider() {
        this.startUptimeMeasurement();
    }

    private void startUptimeMeasurement() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public Object getValue() {
        long value = System.currentTimeMillis() - this.startTime;
        this.valueObj.setValue(value);
        return this.valueObj;
    }

    @Override
    public Object getAverageValue() {
        LongObj currentUptimeObj = (LongObj)this.getValue();
        long currentUptime = currentUptimeObj.longValue();
        currentUptime = Math.max(currentUptime, 0L);
        long avgUptime = (currentUptime + StatisticPrefs.MovingTotalUptime.get()) / (long)(StatisticPrefs.MovingTotalUptimeCount.get() + 1);
        this.avgObj.setValue(avgUptime);
        return this.avgObj;
    }

    @Override
    public Object getMaxValue() {
        long uptime = System.currentTimeMillis() - this.startTime;
        if (uptime > this.maxObj.getValue()) {
            this.maxObj.setValue(uptime);
        }
        return this.maxObj;
    }

    @Override
    public String toStatisticString(Object value) {
        return TimeFormatUtils.formatSignificantElapsedTime(((LongObj)value).longValue() / 1000L);
    }

    public void saveUptimeStats() {
        LongObj obj = (LongObj)this.getMaxValue();
        StatisticPrefs.MaximalUptime.set(new Long(obj.getValue()));
        long mtu = StatisticPrefs.MovingTotalUptime.get().intValue();
        int mtuCount = StatisticPrefs.MovingTotalUptimeCount.get();
        if (mtuCount >= 25) {
            mtu -= mtu / (long)mtuCount;
            StatisticPrefs.MovingTotalUptime.set(new Long(mtu));
            StatisticPrefs.MovingTotalUptimeCount.set(new Integer(--mtuCount));
        }
        if ((obj = (LongObj)this.getValue()).longValue() > 0L) {
            StatisticPrefs.MovingTotalUptime.set(new Long(mtu += obj.longValue()));
            StatisticPrefs.MovingTotalUptimeCount.set(new Integer(++mtuCount));
        }
    }
}

